## ----setup, include=FALSE-----------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)
require(magrittr)
library(fgdiR)

## -----------------------------------------------------------------------------
data(A_Data)
data(A_data_info)

## -----------------------------------------------------------------------------
ID <- c(rep("Case", 18), rep("Control", 42))
fgdi_out <- FGDI(A_Data, ID, PVE_I = 0.99)

## ----fig.width=6, fig.height=4------------------------------------------------
plot_gait_comparison(1, "Pelvis Tilt", fgdi_out, A_Data, ID, combined=FALSE)

