/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.ucarima;

import jdplus.toolkit.base.api.math.Complex;
import jdplus.toolkit.base.core.math.polynomials.Polynomial;
import jdplus.toolkit.base.core.math.polynomials.UnitRoots;
import jdplus.toolkit.base.core.ucarima.AbstractRootSelector;

public class SeasonalSelector
extends AbstractRootSelector {
    private double m_k = 0.5;
    private double m_epsphi = 2.0;
    private int frequency;

    public SeasonalSelector() {
        this.frequency = 12;
    }

    public SeasonalSelector(int freq) {
        this.frequency = freq;
    }

    public SeasonalSelector(int freq, double epsphi) {
        this.frequency = freq;
        this.m_epsphi = epsphi;
    }

    @Override
    public boolean accept(Complex root) {
        if (Math.abs(root.getIm()) < 1.0E-6) {
            return 1.0 / root.getRe() < -this.m_k;
        }
        double pi = Math.PI * 2 / (double)this.frequency;
        double arg = Math.abs(root.arg());
        double eps = this.m_epsphi / 180.0 * Math.PI;
        for (int i = 1; i <= this.frequency / 2; ++i) {
            if (!(Math.abs(pi * (double)i - arg) <= eps)) continue;
            return true;
        }
        return false;
    }

    public int getFrequency() {
        return this.frequency;
    }

    public double getK() {
        return this.m_k;
    }

    public double getTolerance() {
        return this.m_epsphi;
    }

    public void setFrequency(int value) {
        this.frequency = value;
    }

    public void setK(double value) {
        this.m_k = value;
    }

    public void setTolerance(double value) {
        this.m_epsphi = value;
    }

    @Override
    public boolean selectUnitRoots(Polynomial p) {
        Polynomial.Division div;
        this.selected = Polynomial.ONE;
        this.notSelected = p;
        if (this.frequency == 1) {
            return false;
        }
        Polynomial S = UnitRoots.S(this.frequency, 1);
        while ((div = Polynomial.divide(this.notSelected, S)).isExact()) {
            this.selected = this.selected.times(S);
            this.notSelected = div.getQuotient();
            if (p.degree() >= S.degree()) continue;
        }
        return this.selected.degree() > 0;
    }
}

