/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.ssf.ckms;

import jdplus.toolkit.base.core.ssf.ISsfDynamics;
import jdplus.toolkit.base.core.ssf.ISsfLoading;
import jdplus.toolkit.base.core.ssf.UpdateInformation;
import jdplus.toolkit.base.core.ssf.ckms.CkmsInitializer;
import jdplus.toolkit.base.core.ssf.ckms.CkmsState;
import jdplus.toolkit.base.core.ssf.univariate.IFilteringResults;
import jdplus.toolkit.base.core.ssf.univariate.ISsf;
import jdplus.toolkit.base.core.ssf.univariate.ISsfData;

public class CkmsFilter {
    private double eps = 1.0E-15;
    private double neps;
    private final IFastFilterInitializer initializer;
    private ISsfLoading loading;
    private ISsfDynamics dynamics;
    private ISsfData data;
    private CkmsState state;
    private UpdateInformation pe;
    private double[] L;
    private double[] M;
    private int steadypos;

    public CkmsFilter() {
        this.initializer = new CkmsInitializer();
    }

    public CkmsFilter(IFastFilterInitializer initializer) {
        this.initializer = initializer;
    }

    public CkmsState getFinalState() {
        return this.state;
    }

    public void setEpsilon(double eps) {
        this.eps = eps;
    }

    public double getEpsilon() {
        return this.eps;
    }

    public int getSteadyStatePosition() {
        return this.steadypos;
    }

    private int initialize(ISsf ssf) {
        this.steadypos = -1;
        this.dynamics = ssf.dynamics();
        this.loading = ssf.loading();
        int dim = ssf.getStateDim();
        this.state = new CkmsState(dim);
        this.pe = new UpdateInformation(dim);
        int t = this.initializer.initializeFilter(this.state, this.pe, ssf, this.data);
        if (t < 0) {
            return -1;
        }
        this.M = this.pe.M().getStorage();
        this.L = this.state.l.getStorage();
        this.neps = this.eps * this.pe.getVariance();
        return t;
    }

    public boolean process(ISsf ssf, ISsfData data, IFilteringResults rslts) {
        this.data = data;
        int t = this.initialize(ssf);
        if (t < 0) {
            return false;
        }
        int end = this.data.length();
        while (t < end) {
            this.error(t);
            if (rslts != null) {
                rslts.save(t, this.pe);
            }
            this.update(t);
            this.next(t++);
        }
        return true;
    }

    private void next(int t) {
        if (this.steadypos < 0) {
            double zl = this.loading.ZX(0, this.state.l);
            if (Math.abs(zl) > this.neps) {
                double f = this.pe.getVariance();
                double zlv = zl / f;
                f -= zl * zlv;
                int i = 0;
                while (i < this.L.length) {
                    double l = this.L[i];
                    int n = i;
                    this.L[n] = this.L[n] - this.M[i] * zlv;
                    int n2 = i++;
                    this.M[n2] = this.M[n2] - l * zlv;
                }
                this.pe.setVariance(f);
            } else if (this.state.l.norm2() <= this.eps) {
                this.steadypos = t;
            }
            this.dynamics.TX(t, this.state.l);
        }
        this.dynamics.TX(t, this.state.a);
    }

    private void update(int t) {
        this.state.a.addAY(this.pe.get() / this.pe.getVariance(), this.pe.M());
    }

    private void error(int t) {
        double y = this.data.get(t);
        this.pe.set(y - this.loading.ZX(t, this.state.a), this.data.isConstraint(t));
    }

    public static interface IFastFilterInitializer {
        public int initializeFilter(CkmsState var1, UpdateInformation var2, ISsf var3, ISsfData var4);
    }
}

