/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.discrete;

import jdplus.toolkit.base.api.data.DoubleSeq;
import jdplus.toolkit.base.api.data.DoubleSeqCursor;
import jdplus.toolkit.base.core.data.DataBlock;
import jdplus.toolkit.base.core.data.DataBlockIterator;
import jdplus.toolkit.base.core.discrete.DiscreteModel;
import jdplus.toolkit.base.core.discrete.ICumulativeDistributionFunction;
import jdplus.toolkit.base.core.math.functions.DefaultDomain;
import jdplus.toolkit.base.core.math.functions.IFunction;
import jdplus.toolkit.base.core.math.functions.IFunctionDerivatives;
import jdplus.toolkit.base.core.math.functions.IFunctionPoint;
import jdplus.toolkit.base.core.math.functions.IParametersDomain;
import jdplus.toolkit.base.core.math.matrices.FastMatrix;
import jdplus.toolkit.base.core.math.matrices.SymmetricMatrix;

class llFn
implements IFunction {
    DiscreteModel model;

    llFn(DiscreteModel model) {
        this.model = model;
    }

    double[] probabilities(DoubleSeq b) {
        int n = this.model.X.getRowsCount();
        double[] p = new double[n];
        DataBlock Xb = DataBlock.of(p);
        DoubleSeqCursor bcur = b.cursor();
        DataBlockIterator cols = this.model.X.columnsIterator();
        Xb.setAY(bcur.getAndNext(), cols.next());
        while (cols.hasNext()) {
            Xb.addAY(bcur.getAndNext(), cols.next());
        }
        for (int pos = 0; pos < n; ++pos) {
            double d = p[pos];
            double z = this.model.cdf.f(d);
            if (Double.isNaN(z)) {
                z = d < 0.0 ? 0.0 : 1.0;
            }
            p[pos] = z;
        }
        return p;
    }

    double logLikelihood(DoubleSeq b) {
        double[] p = this.probabilities(b);
        double ll = 0.0;
        int[] y = this.model.getY();
        for (int pos = 0; pos < y.length; ++pos) {
            double pcur = p[pos];
            int ycur = y[pos];
            if (ycur != 0) {
                if (pcur == 0.0) {
                    return Double.NaN;
                }
                if (pcur == 1.0) continue;
                ll += Math.log(pcur);
                continue;
            }
            if (pcur == 1.0) {
                return Double.NaN;
            }
            if (pcur == 0.0) continue;
            ll += Math.log(1.0 - pcur);
        }
        return ll;
    }

    public double[] loglikelihoodGradient(DoubleSeq b) {
        double[] g = new double[b.length()];
        DataBlock G = DataBlock.of(g);
        DataBlockIterator rows = this.model.X.rowsIterator();
        int pos = 0;
        ICumulativeDistributionFunction cdf = this.model.getCdf();
        while (rows.hasNext()) {
            int ycur;
            DataBlock row = rows.next();
            double d = row.dot(b);
            double p = cdf.f(d);
            double dp = cdf.df(d);
            if ((ycur = this.model.y[pos++]) != 0) {
                if (p == 0.0) continue;
                G.addAY(dp / p, row);
                continue;
            }
            if (p == 1.0) continue;
            G.addAY(-dp / (1.0 - p), row);
        }
        return g;
    }

    public void logLikelihoodHessian(DoubleSeq b, FastMatrix h) {
        DataBlockIterator rows = this.model.X.rowsIterator();
        int pos = 0;
        ICumulativeDistributionFunction cdf = this.model.getCdf();
        while (rows.hasNext()) {
            int y;
            DataBlock X = rows.next();
            FastMatrix XX = SymmetricMatrix.xxt(X);
            double x = X.dot(b);
            double f = cdf.f(x);
            double cf = 1.0 - f;
            double df = cdf.df(x);
            double d2f = cdf.d2f(x);
            if ((y = this.model.y[pos++]) != 0) {
                h.addAY((f * d2f - df * df) / (f * f), XX);
                continue;
            }
            h.addAY(-(cf * d2f + df * df) / (cf * cf), XX);
        }
    }

    @Override
    public IParametersDomain getDomain() {
        return new DefaultDomain(this.model.getX().getColumnsCount(), 1.0E-8);
    }

    @Override
    public IFunctionPoint evaluate(DoubleSeq parameters) {
        return new Point(parameters);
    }

    class Point
    implements IFunctionPoint {
        private final DoubleSeq parameters;

        Point(DoubleSeq p) {
            this.parameters = p;
        }

        @Override
        public llFn getFunction() {
            return llFn.this;
        }

        @Override
        public IFunctionDerivatives derivatives() {
            return new dllFn(this.parameters);
        }

        @Override
        public DoubleSeq getParameters() {
            return this.parameters;
        }

        @Override
        public double getValue() {
            return -llFn.this.logLikelihood(this.parameters);
        }
    }

    class dllFn
    implements IFunctionDerivatives {
        private final DoubleSeq parameters;

        dllFn(DoubleSeq p) {
            this.parameters = p;
        }

        @Override
        public IFunction getFunction() {
            return llFn.this;
        }

        @Override
        public DoubleSeq gradient() {
            double[] g = llFn.this.loglikelihoodGradient(this.parameters);
            return DoubleSeq.onMapping((int)g.length, i -> -g[i]);
        }

        @Override
        public void hessian(FastMatrix hessian) {
            llFn.this.logLikelihoodHessian(this.parameters, hessian);
            hessian.chs();
        }
    }
}

