/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.api.information.formatters;

import java.text.NumberFormat;
import java.util.Locale;

public interface InformationFormatter {
    public static final int NO_INDEX = 0;

    public static NumberFormat df(Locale locale, int ndec) {
        NumberFormat df = NumberFormat.getNumberInstance(locale);
        df.setMaximumFractionDigits(ndec);
        df.setGroupingUsed(false);
        return df;
    }

    public static NumberFormat df3(Locale locale) {
        return InformationFormatter.df(locale, 3);
    }

    public static NumberFormat df4(Locale locale) {
        return InformationFormatter.df(locale, 4);
    }

    public static NumberFormat df6(Locale locale) {
        return InformationFormatter.df(locale, 6);
    }

    public static String format(NumberFormat fmt, double val) {
        if (Double.isInfinite(val)) {
            if (val < 0.0) {
                return "-inf";
            }
            return "inf";
        }
        if (Double.isNaN(val)) {
            return "nan";
        }
        return fmt.format(val);
    }

    public static String format3(Locale locale, double val) {
        return InformationFormatter.format(InformationFormatter.df3(locale), val);
    }

    public static String format4(Locale locale, double val) {
        return InformationFormatter.format(InformationFormatter.df4(locale), val);
    }

    public static String format6(Locale locale, double val) {
        return InformationFormatter.format(InformationFormatter.df6(locale), val);
    }

    public String format(Object var1, int var2, Locale var3);

    default public int getDefaultRepresentationLength() {
        return 1;
    }
}

