/*
 * Decompiled with CFR 0.152.
 */
package internal.toolkit.base.tsp.util;

import internal.toolkit.base.tsp.util.MapCache;
import java.io.File;
import java.util.Map;
import lombok.Generated;
import lombok.NonNull;
import org.jspecify.annotations.Nullable;

public final class FileMapCache<K, V>
implements MapCache<K, V> {
    @NonNull
    private final Map<K, V> map;
    @NonNull
    private final File file;
    private long lastModified = Long.MIN_VALUE;

    @Override
    public void put(@NonNull K key, @NonNull V value) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        this.map.put(key, value);
    }

    @Override
    public @Nullable V get(@NonNull K key) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        V result = this.map.get(key);
        if (result == null) {
            return null;
        }
        long timInMillis = this.file.lastModified();
        if (timInMillis != this.lastModified) {
            this.lastModified = timInMillis;
            this.map.clear();
            return null;
        }
        return result;
    }

    @Override
    @NonNull
    @Generated
    public Map<K, V> getMap() {
        return this.map;
    }

    @NonNull
    @Generated
    public File getFile() {
        return this.file;
    }

    @Generated
    public long getLastModified() {
        return this.lastModified;
    }

    @Generated
    public FileMapCache(@NonNull Map<K, V> map, @NonNull File file) {
        if (map == null) {
            throw new NullPointerException("map is marked non-null but is null");
        }
        if (file == null) {
            throw new NullPointerException("file is marked non-null but is null");
        }
        this.map = map;
        this.file = file;
    }
}

