/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.model.visitors;

import java.lang.reflect.Field;
import java.util.Collections;
import java.util.List;
import org.dmg.pmml.Apply;
import org.dmg.pmml.Expression;
import org.dmg.pmml.Interval;
import org.dmg.pmml.InvalidValueTreatmentMethod;
import org.dmg.pmml.MiningField;
import org.dmg.pmml.MissingValueTreatmentMethod;
import org.dmg.pmml.OutputField;
import org.dmg.pmml.PMMLAttributes;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.ResultFeature;
import org.dmg.pmml.SimplePredicate;
import org.dmg.pmml.TargetValue;
import org.dmg.pmml.TextIndexNormalization;
import org.dmg.pmml.VisitorAction;
import org.jpmml.model.InvalidAttributeException;
import org.jpmml.model.InvalidElementException;
import org.jpmml.model.InvalidMarkupException;
import org.jpmml.model.MisplacedAttributeException;
import org.jpmml.model.MisplacedElementException;
import org.jpmml.model.ReflectionUtil;
import org.jpmml.model.annotations.CollectionSize;
import org.jpmml.model.visitors.MarkupInspector;

public class InvalidMarkupInspector
extends MarkupInspector<InvalidMarkupException> {
    @Override
    public VisitorAction visit(PMMLObject object) {
        List<Field> fields = ReflectionUtil.getFields(object.getClass());
        for (Field field : fields) {
            boolean valid;
            CollectionSize collectionSize = field.getAnnotation(CollectionSize.class);
            if (collectionSize == null) continue;
            Field collectionField = ReflectionUtil.getField(object.getClass(), collectionSize.value());
            Object sizeValue = ReflectionUtil.getFieldValue(field, object);
            Object collectionValue = ReflectionUtil.getFieldValue(collectionField, object);
            if (sizeValue == null) continue;
            int size = (Integer)sizeValue;
            List collection = (List)collectionValue;
            CollectionSize.Operator operator = collectionSize.operator();
            switch (operator) {
                case EQUAL: 
                case GREATER_OR_EQUAL: {
                    valid = operator.check(size, collection != null ? collection : Collections.emptyList());
                    break;
                }
                default: {
                    valid = true;
                }
            }
            if (valid) continue;
            this.report(new InvalidAttributeException(object, field, sizeValue));
        }
        return super.visit(object);
    }

    @Override
    public VisitorAction visit(Apply apply) {
        InvalidValueTreatmentMethod invalidValueTreatmentMethod = apply.getInvalidValueTreatment();
        switch (invalidValueTreatmentMethod) {
            case AS_VALUE: {
                this.report(new InvalidAttributeException(apply, invalidValueTreatmentMethod));
                break;
            }
        }
        return super.visit(apply);
    }

    @Override
    public VisitorAction visit(Interval interval) {
        Number leftMargin = interval.getLeftMargin();
        Number rightMargin = interval.getRightMargin();
        if (leftMargin != null && rightMargin != null && Double.compare(leftMargin.doubleValue(), rightMargin.doubleValue()) > 0) {
            this.report(new InvalidElementException(interval));
        }
        return super.visit(interval);
    }

    @Override
    public VisitorAction visit(MiningField miningField) {
        InvalidValueTreatmentMethod invalidValueTreatmentMethod = miningField.getInvalidValueTreatment();
        Object invalidValueReplacement = miningField.getInvalidValueReplacement();
        switch (invalidValueTreatmentMethod) {
            case AS_IS: {
                if (invalidValueReplacement == null) break;
                break;
            }
            case AS_MISSING: 
            case RETURN_INVALID: {
                if (invalidValueReplacement == null) break;
                throw new MisplacedAttributeException(miningField, PMMLAttributes.MININGFIELD_INVALIDVALUEREPLACEMENT, invalidValueReplacement);
            }
        }
        MissingValueTreatmentMethod missingValueTreatmentMethod = miningField.getMissingValueTreatment();
        Object missingValueReplacement = miningField.getMissingValueReplacement();
        if (missingValueTreatmentMethod == null) {
            missingValueTreatmentMethod = MissingValueTreatmentMethod.AS_IS;
        }
        switch (missingValueTreatmentMethod) {
            case RETURN_INVALID: {
                if (missingValueReplacement == null) break;
                this.report(new MisplacedAttributeException(miningField, PMMLAttributes.MININGFIELD_MISSINGVALUEREPLACEMENT, missingValueReplacement));
                break;
            }
        }
        Number lowValue = miningField.getLowValue();
        Number highValue = miningField.getHighValue();
        if (lowValue != null && highValue != null && Double.compare(lowValue.doubleValue(), highValue.doubleValue()) > 0) {
            throw new InvalidElementException(miningField);
        }
        return super.visit(miningField);
    }

    @Override
    public VisitorAction visit(OutputField outputField) {
        ResultFeature resultFeature = outputField.getResultFeature();
        String targetFieldName = outputField.getTargetField();
        if (targetFieldName != null) {
            switch (resultFeature) {
                case TRANSFORMED_VALUE: 
                case DECISION: {
                    Expression expression = outputField.getExpression();
                    if (expression != null) {
                        this.report(new MisplacedElementException(expression));
                    }
                }
                case WARNING: {
                    this.report(new MisplacedAttributeException(outputField, PMMLAttributes.OUTPUTFIELD_TARGETFIELD, targetFieldName));
                    break;
                }
            }
        }
        return super.visit(outputField);
    }

    @Override
    public VisitorAction visit(SimplePredicate simplePredicate) {
        SimplePredicate.Operator operator = simplePredicate.getOperator();
        if (operator != null) {
            switch (operator) {
                case IS_MISSING: 
                case IS_NOT_MISSING: {
                    if (!simplePredicate.hasValue()) break;
                    this.report(new MisplacedAttributeException(simplePredicate, PMMLAttributes.SIMPLEPREDICATE_VALUE, simplePredicate.getValue()));
                    break;
                }
            }
        }
        return super.visit(simplePredicate);
    }

    @Override
    public VisitorAction visit(TargetValue targetValue) {
        Number defaultValue = targetValue.getDefaultValue();
        Object value = targetValue.getValue();
        Number priorProbability = targetValue.getPriorProbability();
        if (defaultValue != null && (value != null || priorProbability != null)) {
            this.report(new InvalidElementException(targetValue));
        }
        return super.visit(targetValue);
    }

    @Override
    public VisitorAction visit(TextIndexNormalization textIndexNormalization) {
        String wordRE = textIndexNormalization.getWordRE();
        String wordSeparatorCharacterRE = textIndexNormalization.getWordSeparatorCharacterRE();
        if (wordRE != null && wordSeparatorCharacterRE != null) {
            this.report(new InvalidElementException(textIndexNormalization));
        }
        return super.visit(textIndexNormalization);
    }
}

