/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.common.util.preprocessor;

import choco.cp.common.util.preprocessor.AbstractDetector;
import choco.cp.model.CPModel;
import choco.kernel.model.constraints.Constraint;
import choco.kernel.model.variables.Variable;
import gnu.trove.THashMap;
import gnu.trove.TLongObjectHashMap;
import java.util.logging.Level;

public abstract class AbstractAdvancedDetector
extends AbstractDetector {
    protected final TLongObjectHashMap<Constraint> constraintsToAdd = new TLongObjectHashMap();
    protected final TLongObjectHashMap<Constraint> constraintsToDelete = new TLongObjectHashMap();
    protected final TLongObjectHashMap<Variable> variablesToAdd = new TLongObjectHashMap();
    protected final TLongObjectHashMap<Variable> variablesToDelete = new TLongObjectHashMap();
    protected final THashMap<Variable, Variable> variablesToReplace = new THashMap();

    protected AbstractAdvancedDetector(CPModel model) {
        super(model);
    }

    @Override
    public abstract void apply();

    protected final void add(Constraint c) {
        this.constraintsToAdd.put(c.getIndex(), c);
    }

    protected final void delete(Constraint c) {
        this.constraintsToDelete.put(c.getIndex(), c);
    }

    protected final void keep(Constraint c) {
        this.constraintsToDelete.remove(c.getIndex());
    }

    protected final void forget(Constraint c) {
        this.constraintsToAdd.remove(c.getIndex());
    }

    protected final void add(Variable v) {
        this.variablesToAdd.put(v.getIndex(), v);
    }

    protected final void delete(Variable v) {
        this.variablesToDelete.put(v.getIndex(), v);
    }

    protected final void keep(Variable v) {
        this.variablesToDelete.remove(v.getIndex());
    }

    protected final void forget(Variable v) {
        this.variablesToAdd.remove(v.getIndex());
    }

    protected final void replaceBy(Variable outVar, Variable inVar) {
        this.variablesToReplace.put(outVar, inVar);
    }

    @Override
    public final void commit() {
        Constraint c;
        for (long l : this.variablesToAdd.keys()) {
            Variable v = this.variablesToAdd.get(l);
            this.model.addVariables(v);
            if (!LOGGER.isLoggable(Level.CONFIG)) continue;
            LOGGER.config(String.format("..add variable : %s", v.pretty()));
        }
        for (long l : this.constraintsToAdd.keys()) {
            c = this.constraintsToAdd.get(l);
            this.model.addConstraint(c);
            if (!LOGGER.isLoggable(Level.CONFIG)) continue;
            LOGGER.config(String.format("..add constraint : %s", c.pretty()));
        }
        for (long l : this.constraintsToDelete.keys()) {
            c = this.constraintsToDelete.get(l);
            this.model.removeConstraint(c);
            if (!LOGGER.isLoggable(Level.CONFIG)) continue;
            LOGGER.config(String.format("..delete constraint : %s", c.pretty()));
        }
        for (Variable outVar : this.variablesToReplace.keySet()) {
            Variable inVar = this.variablesToReplace.get(outVar);
            for (Constraint c2 : outVar.getConstraints()) {
                c2.replaceBy(outVar, inVar);
                if (!inVar._contains(c2)) {
                    inVar._addConstraint(c2);
                }
                outVar._removeConstraint(c2);
            }
            if (inVar.getHook() == Integer.MIN_VALUE) {
                inVar.setHook(outVar.getHook());
            }
            if (!LOGGER.isLoggable(Level.CONFIG)) continue;
            LOGGER.config(String.format("..%s replaced by : %s", outVar.getName(), inVar.getName()));
        }
        for (long l : this.variablesToDelete.keys()) {
            Variable v = this.variablesToDelete.get(l);
            this.model.removeVariable(v);
            if (!LOGGER.isLoggable(Level.CONFIG)) continue;
            LOGGER.config(String.format("..delete variable : %s", v.pretty()));
        }
    }

    public final void rollback() {
        this.constraintsToAdd.clear();
        this.constraintsToDelete.clear();
        this.variablesToAdd.clear();
        this.variablesToDelete.clear();
        this.variablesToReplace.clear();
    }
}

