# ==============================================================================
# NUETON v2.0: Master Capability Test
# This script demonstrates the "Smart Import" and Batch Calculation features.
# ==============================================================================

# 1. Load the Package
library(NUETON)
library(ggplot2) # Required for the plots

# 2. "Smart Import": Locate the internal test dataset
# This simulates a user loading their own "my_experiment.csv"
csv_path <- system.file("extdata", "nueton_test_full.csv", package = "NUETON")
print(paste("Loading data from:", csv_path))

# 3. Read the Data
raw_data <- read.csv(csv_path)
print("--- Raw Data Loaded (First 6 rows) ---")
print(head(raw_data[, 1:5])) # Showing just first 5 cols for brevity

# 4. The "Overpowered" Batch Calculation
# This one line detects columns and calculates ALL 23 metrics automatically.
results <- calculate_nue_batch(raw_data)

# 5. Verify Output
# We check which new columns were created by comparing to the original names
new_metrics <- setdiff(names(results), names(raw_data))

print("--- Analysis Complete! ---")
print(paste("Total Metrics Calculated:", length(new_metrics)))
print("List of Generated Indicators:")
print(new_metrics)

# 6. Visualization Showcase
# Create a plot for one of the new metrics (e.g., Agronomic Efficiency)
p <- plot_nue_compare(results, x_var = "Treat", y_var = "AE") +
  ggtitle("Agronomic Efficiency (AE) by Treatment") +
  theme_minimal()

print(p)

# Optional: View the full results in RStudio
# View(results)