/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.stats.samples;

import jdplus.toolkit.base.api.data.DoubleSeq;
import jdplus.toolkit.base.api.data.DoubleSeqCursor;
import jdplus.toolkit.base.api.stats.StatisticalTest;
import jdplus.toolkit.base.api.stats.TestType;
import jdplus.toolkit.base.core.dstats.F;
import jdplus.toolkit.base.core.dstats.T;
import jdplus.toolkit.base.core.stats.samples.Population;
import jdplus.toolkit.base.core.stats.tests.TestsUtility;
import lombok.Generated;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public final class Sample {
    private final DoubleSeq data;
    private final int observationsCount;
    private final double mean;
    private final double variance;
    private final Population population;

    public double standardDeviation() {
        return Math.sqrt(this.variance);
    }

    public static Sample build(DoubleSeq sample, boolean skipMissing, Population population) {
        if (!skipMissing) {
            return Sample.buildNoMissing(sample, population == null ? Population.UNKNOWN : population);
        }
        return Sample.buildMissing(sample, population == null ? Population.UNKNOWN : population);
    }

    public static Sample ofResiduals(DoubleSeq residuals) {
        return Sample.buildNoMissing(residuals, Population.ZEROMEAN);
    }

    private static Sample buildNoMissing(DoubleSeq sample, Population population) {
        DoubleSeqCursor reader = sample.cursor();
        int n = sample.length();
        double populationMean = population.getMean();
        if (Double.isNaN(populationMean)) {
            double m = sample.average();
            double ssqc = sample.ssqc(m);
            double v = ssqc / (double)(n - 1);
            return new Sample(sample, n, m, v, population);
        }
        if (populationMean == 0.0) {
            double sx = 0.0;
            double sxx = 0.0;
            for (int i = 0; i < n; ++i) {
                double x = reader.getAndNext();
                sx += x;
                sxx += x * x;
            }
            double m = sx / (double)n;
            double v = sxx / (double)n;
            return new Sample(sample, n, m, v, population);
        }
        double sx = 0.0;
        double sxxc = 0.0;
        for (int i = 0; i < n; ++i) {
            double x = reader.getAndNext();
            double xc = x - populationMean;
            sx += x;
            sxxc += xc * xc;
        }
        double m = sx / (double)n;
        double v = sxxc / (double)n;
        return new Sample(sample, n, m, v, population);
    }

    private static Sample buildMissing(DoubleSeq sample, Population population) {
        DoubleSeqCursor reader = sample.cursor();
        int n = sample.length();
        double populationMean = population.getMean();
        if (Double.isNaN(populationMean)) {
            int nobs = 0;
            double sx = 0.0;
            for (int i = 0; i < n; ++i) {
                double x = reader.getAndNext();
                if (!Double.isFinite(x)) continue;
                sx += x;
                ++nobs;
            }
            double m = sx / (double)nobs;
            double sxxc = 0.0;
            reader.moveTo(0);
            for (int i = 0; i < n; ++i) {
                double x = reader.getAndNext();
                if (!Double.isFinite(x)) continue;
                double z = x - m;
                sxxc += z * z;
            }
            double v = sxxc / (double)(nobs - 1);
            return new Sample(sample, nobs, m, v, population);
        }
        if (populationMean == 0.0) {
            int nobs = 0;
            double sx = 0.0;
            double sxx = 0.0;
            for (int i = 0; i < n; ++i) {
                double x = reader.getAndNext();
                if (!Double.isFinite(x)) continue;
                sx += x;
                sxx += x * x;
                ++nobs;
            }
            double m = sx / (double)nobs;
            double v = sxx / (double)nobs;
            return new Sample(sample, nobs, m, v, population);
        }
        int nobs = 0;
        double sx = 0.0;
        double sxxc = 0.0;
        for (int i = 0; i < n; ++i) {
            double x = reader.getAndNext();
            if (!Double.isFinite(x)) continue;
            double xc = x - populationMean;
            sx += x;
            sxxc += xc * xc;
        }
        double m = sx / (double)nobs;
        double v = sxxc / (double)nobs;
        return new Sample(sample, nobs, m, v, population);
    }

    public static StatisticalTest compareVariances(Sample s0, Sample s1) {
        F f = new F(s1.observationsCount - 1, s0.observationsCount - 1);
        return TestsUtility.testOf(s1.variance / s0.variance, f, TestType.Upper);
    }

    public static StatisticalTest compareMeans(Sample s0, Sample s1, boolean samevar) {
        int df;
        double t;
        int n0 = s0.observationsCount;
        int n1 = s1.observationsCount;
        double v0 = s0.variance;
        double v1 = s1.variance;
        if (samevar) {
            double v = (v0 * (double)(n0 - 1) + v1 * (double)(n1 - 1)) / (double)(n0 + n1 - 2);
            t = (s1.mean - s0.mean) / Math.sqrt(v / (double)n0 + v / (double)n1);
            df = n0 + n1 - 2;
        } else {
            t = (s1.mean - s0.mean) / Math.sqrt(v0 / (double)n0 + v1 / (double)n1);
            df = Math.min(n0 - 1, n1 - 1);
        }
        T dist = new T(df);
        return TestsUtility.testOf(t, dist, TestType.TwoSided);
    }

    @Generated
    public DoubleSeq data() {
        return this.data;
    }

    @Generated
    public int observationsCount() {
        return this.observationsCount;
    }

    @Generated
    public double mean() {
        return this.mean;
    }

    @Generated
    public double variance() {
        return this.variance;
    }

    @Generated
    public Population population() {
        return this.population;
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Sample)) {
            return false;
        }
        Sample other = (Sample)o;
        if (this.observationsCount() != other.observationsCount()) {
            return false;
        }
        if (Double.compare(this.mean(), other.mean()) != 0) {
            return false;
        }
        if (Double.compare(this.variance(), other.variance()) != 0) {
            return false;
        }
        DoubleSeq this$data = this.data();
        DoubleSeq other$data = other.data();
        if (this$data == null ? other$data != null : !this$data.equals(other$data)) {
            return false;
        }
        Population this$population = this.population();
        Population other$population = other.population();
        return !(this$population == null ? other$population != null : !((Object)this$population).equals(other$population));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.observationsCount();
        long $mean = Double.doubleToLongBits(this.mean());
        result = result * 59 + (int)($mean >>> 32 ^ $mean);
        long $variance = Double.doubleToLongBits(this.variance());
        result = result * 59 + (int)($variance >>> 32 ^ $variance);
        DoubleSeq $data = this.data();
        result = result * 59 + ($data == null ? 43 : $data.hashCode());
        Population $population = this.population();
        result = result * 59 + ($population == null ? 43 : ((Object)$population).hashCode());
        return result;
    }

    @Generated
    public @NonNull String toString() {
        return "Sample(data=" + String.valueOf(this.data()) + ", observationsCount=" + this.observationsCount() + ", mean=" + this.mean() + ", variance=" + this.variance() + ", population=" + String.valueOf(this.population()) + ")";
    }

    @Generated
    private Sample(DoubleSeq data, int observationsCount, double mean, double variance, Population population) {
        this.data = data;
        this.observationsCount = observationsCount;
        this.mean = mean;
        this.variance = variance;
        this.population = population;
    }
}

