/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.math.matrices.decomposition;

import java.util.Arrays;
import jdplus.toolkit.base.core.data.DataBlockIterator;
import jdplus.toolkit.base.core.math.matrices.FastMatrix;
import jdplus.toolkit.base.core.math.matrices.MatrixException;
import jdplus.toolkit.base.core.math.matrices.MatrixWindow;
import jdplus.toolkit.base.core.math.matrices.decomposition.HouseholderReflection;
import lombok.Generated;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public final class UpperHessenberg {
    private final HouseholderReflection[] householderReflections;
    private final FastMatrix H;

    public static UpperHessenberg of(FastMatrix A) {
        if (!A.isSquare()) {
            throw new MatrixException("m_err_square");
        }
        return new UpperHessenberg(A);
    }

    private UpperHessenberg(FastMatrix A) {
        int n = A.getRowsCount();
        this.H = A.deepClone();
        if (n <= 2) {
            this.householderReflections = null;
        } else {
            this.householderReflections = new HouseholderReflection[n - 2];
            MatrixWindow wnd = this.H.all();
            MatrixWindow rwnd = this.H.all();
            for (int i = 1; i <= this.householderReflections.length; ++i) {
                DataBlockIterator cols = wnd.bvshrink().columnsIterator();
                HouseholderReflection hr = HouseholderReflection.of(cols.next(), true);
                while (cols.hasNext()) {
                    hr.transform(cols.next());
                }
                wnd.bhshrink();
                DataBlockIterator rows = rwnd.bhshrink().rowsIterator();
                while (rows.hasNext()) {
                    hr.transform(rows.next());
                }
                this.householderReflections[i - 1] = hr;
            }
        }
    }

    @Generated
    public HouseholderReflection[] getHouseholderReflections() {
        return this.householderReflections;
    }

    @Generated
    public FastMatrix getH() {
        return this.H;
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UpperHessenberg)) {
            return false;
        }
        UpperHessenberg other = (UpperHessenberg)o;
        if (!Arrays.deepEquals(this.getHouseholderReflections(), other.getHouseholderReflections())) {
            return false;
        }
        FastMatrix this$H = this.getH();
        FastMatrix other$H = other.getH();
        return !(this$H == null ? other$H != null : !this$H.equals(other$H));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + Arrays.deepHashCode(this.getHouseholderReflections());
        FastMatrix $H = this.getH();
        result = result * 59 + ($H == null ? 43 : $H.hashCode());
        return result;
    }

    @Generated
    public @NonNull String toString() {
        return "UpperHessenberg(householderReflections=" + Arrays.deepToString(this.getHouseholderReflections()) + ", H=" + String.valueOf(this.getH()) + ")";
    }
}

