/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.dstats;

import java.util.Formatter;
import java.util.Locale;
import jdplus.toolkit.base.api.dstats.BoundaryType;
import jdplus.toolkit.base.api.dstats.ContinuousDistribution;
import jdplus.toolkit.base.api.dstats.DStatException;
import jdplus.toolkit.base.api.dstats.RandomNumberGenerator;
import jdplus.toolkit.base.api.stats.ProbabilityType;
import jdplus.toolkit.base.core.dstats.Normal;
import jdplus.toolkit.base.core.dstats.SpecialFunctions;

public class LogNormal
implements ContinuousDistribution {
    private final Normal N;

    public LogNormal() {
        this.N = new Normal();
    }

    public LogNormal(double mean, double stdev) {
        this.N = new Normal(mean, stdev);
    }

    public double getDensity(double x) throws DStatException {
        if (x == 0.0) {
            return 0.0;
        }
        return SpecialFunctions.logNormalDensity(x, this.N.getMean(), this.N.getStdev());
    }

    public double getLeftBound() {
        return 0.0;
    }

    public double getRightBound() {
        return Double.POSITIVE_INFINITY;
    }

    public String getDescription() {
        StringBuilder sb = new StringBuilder();
        sb.append("Lognormal with normal mean = ");
        sb.append(this.N.getMean());
        sb.append(" and normal stdev = ");
        sb.append(this.N.getStdev());
        return sb.toString();
    }

    public double getExpectation() throws DStatException {
        return Math.exp(this.N.getMean() + this.N.getVariance() / 2.0);
    }

    public double getProbability(double x, ProbabilityType pt) throws DStatException {
        return this.N.getProbability(Math.log(x), pt);
    }

    public double getProbabilityInverse(double p, ProbabilityType pt) throws DStatException {
        return Math.exp(this.N.getProbabilityInverse(p, pt));
    }

    public double getVariance() throws DStatException {
        double v = this.N.getVariance();
        return (Math.exp(v) - 1.0) * Math.exp(2.0 * this.N.getMean() + v);
    }

    public BoundaryType hasLeftBound() {
        return BoundaryType.Finite;
    }

    public BoundaryType hasRightBound() {
        return BoundaryType.None;
    }

    public boolean isSymmetrical() {
        return false;
    }

    public double random(RandomNumberGenerator rng) throws DStatException {
        return Math.exp(this.N.random(rng));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("LogN(");
        sb.append(new Formatter(Locale.ROOT).format("%g4", this.N.getMean()));
        sb.append(',');
        sb.append(new Formatter(Locale.ROOT).format("%g4", this.N.getStdev()));
        sb.append(')');
        return sb.toString();
    }

    public static double mean(double mu, double stdev) {
        return Math.exp(mu + stdev * stdev / 2.0);
    }

    public static double stdev(double mu, double stdev) {
        double v = stdev * stdev;
        return Math.exp(mu + 0.5 * v) * Math.sqrt(Math.exp(v) - 1.0);
    }

    public static double stdev2(double emu, double stdev) {
        double v = stdev * stdev;
        return emu * Math.exp(0.5 * v) * Math.sqrt(Math.exp(v) - 1.0);
    }
}

