/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.dstats;

import jdplus.toolkit.base.api.dstats.BoundaryType;
import jdplus.toolkit.base.api.dstats.ContinuousDistribution;
import jdplus.toolkit.base.api.dstats.DStatException;
import jdplus.toolkit.base.api.dstats.RandomNumberGenerator;
import jdplus.toolkit.base.api.stats.ProbabilityType;
import jdplus.toolkit.base.core.dstats.Gamma;

public class InverseGamma
implements ContinuousDistribution {
    private final double alpha;
    private final double beta;
    private final Gamma gamma;

    public InverseGamma(double alpha, double beta) {
        this.alpha = alpha;
        this.beta = beta;
        this.gamma = new Gamma(alpha, 1.0 / beta);
    }

    public double getShape() {
        return this.alpha;
    }

    public double getScale() {
        return this.beta;
    }

    public double getDensity(double x) throws DStatException {
        if (x < 0.0) {
            throw new IllegalArgumentException();
        }
        if (x == 0.0) {
            return 0.0;
        }
        if (this.alpha == 1.0) {
            return this.beta / (x * x) * Math.exp(-this.beta / x);
        }
        return Math.exp((this.alpha + 1.0) * Math.log(this.beta / x) - this.beta / x - Gamma.logGamma(this.alpha)) / this.beta;
    }

    public double getLeftBound() {
        return 0.0;
    }

    public double getRightBound() {
        return Double.POSITIVE_INFINITY;
    }

    public String getDescription() {
        StringBuilder sb = new StringBuilder();
        sb.append("Inverse Gamma with shape = ");
        sb.append(this.alpha);
        sb.append(" and scale = ");
        sb.append(this.beta);
        return sb.toString();
    }

    public double getExpectation() throws DStatException {
        if (this.alpha <= 1.0) {
            return Double.POSITIVE_INFINITY;
        }
        return this.beta / (this.alpha - 1.0);
    }

    public double getProbability(double x, ProbabilityType pt) throws DStatException {
        switch (pt) {
            case Upper: {
                return this.gamma.getProbability(1.0 / x, ProbabilityType.Lower);
            }
            case Lower: {
                return this.gamma.getProbability(1.0 / x, ProbabilityType.Upper);
            }
        }
        return 0.0;
    }

    public double getProbabilityInverse(double p, ProbabilityType pt) throws DStatException {
        switch (pt) {
            case Upper: {
                return 1.0 / this.gamma.getProbabilityInverse(p, ProbabilityType.Lower);
            }
            case Lower: {
                return 1.0 / this.gamma.getProbability(p, ProbabilityType.Upper);
            }
        }
        return Double.NaN;
    }

    public double getVariance() throws DStatException {
        if (this.alpha <= 2.0) {
            return Double.POSITIVE_INFINITY;
        }
        return this.beta * this.beta / ((this.alpha - 1.0) * (this.alpha - 1.0) * (this.alpha - 2.0));
    }

    public BoundaryType hasLeftBound() {
        return BoundaryType.Asymptotical;
    }

    public BoundaryType hasRightBound() {
        return BoundaryType.None;
    }

    public boolean isSymmetrical() {
        return false;
    }

    public double random(RandomNumberGenerator rng) throws DStatException {
        double z = this.gamma.random(rng);
        return 1.0 / z;
    }

    public static double random(RandomNumberGenerator rng, double shape, double scale) {
        return 1.0 / Gamma.random(rng, shape, 1.0 / scale);
    }
}

