## ----include = FALSE----------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)

## ----built--------------------------------------------------------------------
message(paste0('Datetime: ',Sys.Date(),':',Sys.time()))

## ----setup, message=FALSE-----------------------------------------------------
library(repfun)

## ----before-------------------------------------------------------------------
knitr::kable(head(mtcars,5), caption = "Before Invoking repfun::ru_labels()")

## ----after_base---------------------------------------------------------------
df <- repfun::ru_labels(mtcars,varlabels=list(mpg='Miles Per Gallon',cyl='Number of Cylinders'))
knitr::kable(head(df,5), col.names=sapply(df,function(x){attr(x,"label")}),
             caption = "After Invoking repfun::ru_labels() - style = 'base'")

## ----after_hmisc--------------------------------------------------------------
df2 <- repfun::ru_labels(mtcars,varlabels=list(mpg='Miles Per Gallon',
                                       cyl='Number of Cylinders'),style='hmisc')
knitr::kable(head(df,5), col.names=sapply(df2,function(x){attr(x,"label")}),
             caption = "After Invoking repfun::ru_labels() - style = 'hmisc'")


