/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.solver.constraints.reified.leaves.arithm;

import choco.cp.solver.constraints.integer.MaxOfAList;
import choco.kernel.common.util.tools.StringUtils;
import choco.kernel.solver.Solver;
import choco.kernel.solver.constraints.reified.ArithmNode;
import choco.kernel.solver.constraints.reified.INode;
import choco.kernel.solver.constraints.reified.NodeType;
import choco.kernel.solver.variables.integer.IntDomainVar;

public final class MaxNode
extends INode
implements ArithmNode {
    public MaxNode(INode[] subt) {
        super(subt, NodeType.MAX);
    }

    @Override
    public int eval(int[] tuple) {
        int maxeval = Integer.MIN_VALUE;
        for (INode subtree : this.subtrees) {
            maxeval = Math.max(((ArithmNode)((Object)subtree)).eval(tuple), maxeval);
        }
        return maxeval;
    }

    @Override
    public IntDomainVar extractResult(Solver s) {
        int i;
        IntDomainVar[] vs = new IntDomainVar[this.subtrees.length];
        boolean allenum = true;
        for (i = 0; i < this.subtrees.length; ++i) {
            vs[i] = this.subtrees[i].extractResult(s);
            allenum &= vs[i].hasEnumeratedDomain();
        }
        if (vs.length == 1) {
            return vs[0];
        }
        int lb = vs[0].getInf();
        int ub = vs[0].getSup();
        for (i = 1; i < vs.length; ++i) {
            lb = Math.min(lb, vs[i].getInf());
            ub = Math.max(ub, vs[i].getSup());
        }
        IntDomainVar vmax = lb == 0 && ub == 1 ? s.createBooleanVar(StringUtils.randomName()) : (allenum ? s.createEnumIntVar(StringUtils.randomName(), lb, ub) : s.createBoundIntVar(StringUtils.randomName(), lb, ub));
        IntDomainVar[] tmpVars = new IntDomainVar[vs.length + 1];
        tmpVars[0] = vmax;
        System.arraycopy(vs, 0, tmpVars, 1, vs.length);
        s.post(new MaxOfAList(s.getEnvironment(), tmpVars));
        return vmax;
    }

    @Override
    public String pretty() {
        StringBuilder s = new StringBuilder("max(");
        for (int i = 0; i < this.subtrees.length - 1; ++i) {
            s.append(this.subtrees[i].pretty()).append(",");
        }
        return s.append(this.subtrees[this.subtrees.length - 1].pretty()).append(")").toString();
    }
}

