## ----include = FALSE----------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  echo = TRUE, 
  warning = FALSE, 
  message = FALSE, 
  dpi=400,
  comment = "#>",
  #fig.path = "man/figures/README-",
  out.width = "100%",
  fig.align = "center"
)

## ----eval = FALSE-------------------------------------------------------------
# # install.packages("pak")
# pak::pak("CyGei/linktree")
# library(linktree)

## ----eval = TRUE, echo= FALSE-------------------------------------------------
library(linktree)

## ----fig.width=8, fig.height=6------------------------------------------------
delta <- seq(-1, 1, 0.1)
gamma <- delta2gamma(delta)
plot(gamma, delta, type = "l")
points(1, 0, col = "red", pch = 16)  # Homogeneous

## -----------------------------------------------------------------------------
#?sim_tree
true_gammas <- c(HCW = 2, patient = 1/1.25)
sizes <- c(HCW = 100, patient = 350)
# data(sim_tree) 
sim_tree <- read.csv("https://raw.githubusercontent.com/CyGei/linktree/refs/heads/main/vignettes/sim_tree.csv")
head(sim_tree)

## ----message=FALSE, warning=FALSE---------------------------------------------
library(epicontacts)

x <- epicontacts::make_epicontacts(
  linelist = sim_tree[, c("group", "id", "date_infection", "date_onset")],
  contacts = sim_tree[, c("source", "id", "source_group", "group")],
  id = "id",
  from = "source",
  to = "id",
  directed = TRUE
)

plot(x,
    method = "visNetwork",
    label = FALSE,
    node_color = "group", 
    node_shape = "group",
    shapes = c(patient = "bed", HCW = "user-md"),
    edge_color = "source_group",
    edge_width = 1,
    node_size = 20,
    col_pal = epicontacts::spectral,
    edge_col_pal = epicontacts::spectral
  )

## -----------------------------------------------------------------------------
est_delta <- get_delta(
  from = sim_tree$source_group,
  to = sim_tree$group,
  f = sizes,
)
true_deltas <- gamma2delta(true_gammas)

plot(est_delta, main = "Estimated vs True assortativity coefficients")
abline(h = true_deltas, col = c("#d53e4f", "#3288bd"), lty = 2)
legend("topright", legend = c("HCW (truth)", "patient (truth)"), fill = c("#d53e4f", "#3288bd"), bty = "n")


