/*
 * Decompiled with CFR 0.152.
 */
package com.github.javacliparser;

import com.github.javacliparser.AbstractClassOption;
import com.github.javacliparser.Configurable;
import com.github.javacliparser.JavaCLIParser;
import com.github.javacliparser.Option;
import com.github.javacliparser.Options;
import java.io.File;

public class ClassOption
extends AbstractClassOption {
    private static final long serialVersionUID = 1L;

    public ClassOption(String name, char cliChar, String purpose, Class<?> requiredType, String defaultCLIString) {
        super(name, cliChar, purpose, requiredType, defaultCLIString);
    }

    public ClassOption(String name, char cliChar, String purpose, Class<?> requiredType, String defaultCLIString, String nullString) {
        super(name, cliChar, purpose, requiredType, defaultCLIString, nullString);
    }

    @Override
    public String getValueAsCLIString() {
        if (this.currentValue == null && this.nullString != null) {
            return this.nullString;
        }
        return ClassOption.objectToCLIString(this.currentValue, this.requiredType);
    }

    @Override
    public void setValueViaCLIString(String s) {
        if (this.nullString != null && (s == null || s.length() == 0 || s.equals(this.nullString))) {
            this.currentValue = null;
        } else {
            try {
                this.currentValue = ClassOption.cliStringToObject(s, this.requiredType, null);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Problems with option: " + this.getName(), e);
            }
        }
    }

    public static String objectToCLIString(Object obj, Class<?> requiredType) {
        JavaCLIParser config;
        String subOptions;
        if (obj == null) {
            return "";
        }
        if (obj instanceof File) {
            return "file:" + ((File)obj).getPath();
        }
        if (obj instanceof String) {
            return "inmem:" + obj;
        }
        String className = ClassOption.classToCLIString(obj.getClass(), requiredType);
        if (obj instanceof Configurable && (subOptions = (config = new JavaCLIParser(obj, "")).getOptions().getAsCLIString()).length() > 0) {
            return className + " " + subOptions;
        }
        return className;
    }

    public static Object createObject(String cliString, Class<?> requiredType) throws Exception {
        return ClassOption.cliStringToObject(cliString, requiredType, null);
    }

    public static Object createObject(String[] args, Class<?> requiredType) throws Exception {
        StringBuilder cliString = new StringBuilder();
        for (int i = 0; i < args.length; ++i) {
            cliString.append(" ").append(args[i]);
        }
        return ClassOption.cliStringToObject(cliString.toString(), requiredType, null);
    }

    public static Object cliStringToObject(String cliString, Class<?> requiredType, Option[] externalOptions) throws Exception {
        Object classInstance;
        Class<?> classObject;
        String classOptions;
        String className;
        if (cliString.startsWith("file:")) {
            return new File(cliString.substring("file:".length()));
        }
        if (cliString.startsWith("inmem:")) {
            return cliString.substring("inmem:".length());
        }
        int firstSpaceIndex = (cliString = cliString.trim()).indexOf(32, 0);
        if (firstSpaceIndex > 0) {
            className = cliString.substring(0, firstSpaceIndex);
            classOptions = cliString.substring(firstSpaceIndex + 1, cliString.length());
            classOptions = classOptions.trim();
        } else {
            className = cliString;
            classOptions = "";
        }
        try {
            classObject = Class.forName(className);
        }
        catch (Throwable t1) {
            try {
                classObject = Class.forName(requiredType.getPackage().getName() + "." + className);
            }
            catch (Throwable t3) {
                throw new Exception("Class not found: " + className);
            }
        }
        try {
            classInstance = classObject.newInstance();
        }
        catch (Exception ex) {
            throw new Exception("Problem creating instance of class: " + className, ex);
        }
        if (requiredType.isInstance(classInstance)) {
            Options options = new Options();
            JavaCLIParser config = null;
            if (externalOptions != null) {
                for (Option option : externalOptions) {
                    options.addOption(option);
                }
            }
            if (classInstance instanceof Configurable) {
                Option[] objectOptions;
                config = new JavaCLIParser(classInstance, "");
                for (Option option : objectOptions = config.getOptions().getOptionArray()) {
                    options.addOption(option);
                }
            }
            try {
                options.setViaCLIString(classOptions);
            }
            catch (Exception ex) {
                throw new Exception("Problem with options to '" + className + "'." + "\n\nValid options for " + className + ":\n" + config == null ? "" : config.getOptions().getHelpString(), ex);
            }
            finally {
                options.removeAllOptions();
            }
        } else {
            throw new Exception("Class named '" + className + "' is not an instance of " + requiredType.getName() + ".");
        }
        return classInstance;
    }
}

