/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.nary.alldifferentprec;

import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.stream.IntStream;
import org.chocosolver.solver.Priority;
import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.constraints.nary.alldifferent.algo.AlgoAllDiffBC;
import org.chocosolver.solver.constraints.nary.alldifferentprec.AllDiffPrec;
import org.chocosolver.solver.constraints.nary.alldifferentprec.AllDiffPrecMoreThanBc;
import org.chocosolver.solver.constraints.nary.alldifferentprec.FilterAllDiffPrec;
import org.chocosolver.solver.constraints.nary.alldifferentprec.GreedyBoundSupport;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.util.ESat;
import org.chocosolver.util.objects.graphs.DirectedGraph;
import org.chocosolver.util.objects.setDataStructures.ISetIterator;
import org.chocosolver.util.objects.setDataStructures.SetType;

public class PropAllDiffPrec
extends Propagator<IntVar> {
    private final IntVar[] variables;
    private final boolean[][] precedence;
    private final FilterAllDiffPrec filter;
    private final AlgoAllDiffBC allDiffBC;
    private final DirectedGraph precGraph;
    private final int[] topologicalTraversal;

    public PropAllDiffPrec(IntVar[] variables, int[][] predecessors, int[][] successors, String filter) {
        this(variables, PropAllDiffPrec.buildPrecedence(predecessors, successors), filter);
    }

    public PropAllDiffPrec(IntVar[] variables, boolean[][] precedence, String filter) {
        this(variables, precedence, PropAllDiffPrec.buildFilter(variables, precedence, filter));
    }

    public PropAllDiffPrec(IntVar[] variables, boolean[][] precedence, FilterAllDiffPrec filter) {
        super((Variable[])variables, (Priority)filter.getPriority(), false);
        this.variables = variables;
        this.precedence = precedence;
        this.filter = filter;
        if (filter instanceof AllDiffPrec) {
            this.allDiffBC = new AlgoAllDiffBC(this);
            this.allDiffBC.reset((IntVar[])this.vars);
        } else {
            this.allDiffBC = null;
        }
        this.precGraph = PropAllDiffPrec.buildPrecGraph(precedence);
        this.topologicalTraversal = PropAllDiffPrec.buildTopologicalTraversal(this.precGraph);
    }

    @Override
    public int getPropagationConditions(int vIdx) {
        return this.filter.getPropagationConditions(vIdx);
    }

    private boolean updateBound(boolean lb) throws ContradictionException {
        boolean hasFiltered = false;
        for (int k = 0; k < this.topologicalTraversal.length; ++k) {
            ISetIterator iterator;
            int var = lb ? this.topologicalTraversal[k] : this.topologicalTraversal[this.topologicalTraversal.length - 1 - k];
            ISetIterator iSetIterator = iterator = lb ? this.precGraph.getSuccessorsOf(var).iterator() : this.precGraph.getPredecessorsOf(var).iterator();
            while (iterator.hasNext()) {
                int rel = iterator.nextInt();
                if (lb) {
                    if (!this.variables[rel].updateLowerBound(this.variables[var].getLB() + 1, this)) continue;
                    hasFiltered = true;
                    continue;
                }
                if (!this.variables[rel].updateUpperBound(this.variables[var].getUB() - 1, this)) continue;
                hasFiltered = true;
            }
        }
        return hasFiltered;
    }

    private void filterPrecedenceAndBounds() throws ContradictionException {
        boolean hasFiltered;
        do {
            hasFiltered = this.updateBound(true);
            hasFiltered |= this.updateBound(false);
            if (this.allDiffBC == null) continue;
            hasFiltered |= this.allDiffBC.filter();
        } while (hasFiltered);
    }

    @Override
    public void propagate(int evtmask) throws ContradictionException {
        boolean hasFiltered;
        do {
            this.filterPrecedenceAndBounds();
        } while (hasFiltered = this.filter.propagate(this.precGraph, this.topologicalTraversal, this));
    }

    @Override
    public ESat isEntailed() {
        if (this.isCompletelyInstantiated()) {
            for (int i = 0; i < this.variables.length; ++i) {
                for (int j = i + 1; j < this.variables.length; ++j) {
                    if (this.variables[i].getValue() != this.variables[j].getValue() && (!this.precedence[i][j] || this.variables[i].getValue() <= this.variables[j].getValue()) && (!this.precedence[j][i] || this.variables[i].getValue() >= this.variables[j].getValue())) continue;
                    return ESat.FALSE;
                }
            }
            return ESat.TRUE;
        }
        return ESat.UNDEFINED;
    }

    public static int[][] buildAncestors(int[][] predecessors, int[][] successors) {
        int j;
        int i;
        int n = predecessors.length;
        int[][] ancestors = new int[n][];
        HashSet[] sets = new HashSet[n];
        LinkedList<Integer> list = new LinkedList<Integer>();
        boolean[] done = new boolean[n];
        for (i = 0; i < n; ++i) {
            sets[i] = new HashSet(n);
            if (predecessors[i].length != 0) continue;
            list.addLast(i);
        }
        while (!list.isEmpty()) {
            i = (Integer)list.removeFirst();
            if (done[i]) continue;
            boolean allDone = true;
            for (j = 0; j < predecessors[i].length && allDone; ++j) {
                allDone = done[predecessors[i][j]];
            }
            if (!allDone) continue;
            for (j = 0; j < predecessors[i].length; ++j) {
                sets[i].add(predecessors[i][j]);
                sets[i].addAll(sets[predecessors[i][j]]);
            }
            for (j = 0; j < successors[i].length; ++j) {
                list.addLast(successors[i][j]);
            }
            done[i] = true;
        }
        for (i = 0; i < n; ++i) {
            ancestors[i] = new int[sets[i].size()];
            Iterator iter = sets[i].iterator();
            j = 0;
            while (iter.hasNext()) {
                ancestors[i][j++] = (Integer)iter.next();
            }
        }
        return ancestors;
    }

    public static int[][] buildDescendants(int[][] predecessors, int[][] successors) {
        int j;
        int i;
        int n = successors.length;
        int[][] descendants = new int[n][];
        HashSet[] sets = new HashSet[n];
        LinkedList<Integer> list = new LinkedList<Integer>();
        boolean[] done = new boolean[n];
        for (i = 0; i < n; ++i) {
            sets[i] = new HashSet();
            if (successors[i].length != 0) continue;
            list.addLast(i);
        }
        while (!list.isEmpty()) {
            i = (Integer)list.removeFirst();
            if (done[i]) continue;
            boolean allDone = true;
            for (j = 0; j < successors[i].length && allDone; ++j) {
                allDone = done[successors[i][j]];
            }
            if (!allDone) continue;
            for (j = 0; j < successors[i].length; ++j) {
                sets[i].add(successors[i][j]);
                sets[i].addAll(sets[successors[i][j]]);
            }
            for (j = 0; j < predecessors[i].length; ++j) {
                list.addLast(predecessors[i][j]);
            }
            done[i] = true;
        }
        for (i = 0; i < n; ++i) {
            descendants[i] = new int[sets[i].size()];
            Iterator iter = sets[i].iterator();
            j = 0;
            while (iter.hasNext()) {
                descendants[i][j++] = (Integer)iter.next();
            }
        }
        return descendants;
    }

    public static boolean contains(int[] a2, int v) {
        return PropAllDiffPrec.contains(a2, v, a2.length);
    }

    public static boolean contains(int[] a2, int v, int maxIdx) {
        for (int i = 0; i < maxIdx; ++i) {
            if (a2[i] != v) continue;
            return true;
        }
        return false;
    }

    public static boolean[][] buildPrecedence(int[][] predecessors, int[][] successors) {
        return PropAllDiffPrec.buildPrecedence(predecessors, successors, false);
    }

    public static boolean[][] buildPrecedence(int[][] predecessors, int[][] successors, boolean alreadyComputed) {
        int[][] ancestors = alreadyComputed ? predecessors : PropAllDiffPrec.buildAncestors(predecessors, successors);
        int[][] descendants = alreadyComputed ? successors : PropAllDiffPrec.buildDescendants(predecessors, successors);
        int n = predecessors.length;
        boolean[][] precedence = new boolean[n][n];
        for (int i = 0; i < n; ++i) {
            precedence[i][i] = false;
            for (int j = i + 1; j < n; ++j) {
                if (PropAllDiffPrec.contains(ancestors[i], j)) {
                    precedence[j][i] = true;
                    continue;
                }
                if (!PropAllDiffPrec.contains(descendants[i], j)) continue;
                precedence[i][j] = true;
            }
        }
        return precedence;
    }

    public static DirectedGraph buildPrecGraph(boolean[][] precedence) {
        int n = precedence.length;
        DirectedGraph precGraph = new DirectedGraph(n, SetType.BITSET, true);
        for (int v = 0; v < n; ++v) {
            for (int w = v + 1; w < n; ++w) {
                if (precedence[v][w]) {
                    precGraph.addEdge(v, w);
                    continue;
                }
                if (!precedence[w][v]) continue;
                precGraph.addEdge(w, v);
            }
        }
        return precGraph;
    }

    public static int[] buildTopologicalTraversal(DirectedGraph precGraph) {
        int v;
        int n = precGraph.getNbMaxNodes();
        int[] depth = new int[n];
        LinkedList<Integer> queue = new LinkedList<Integer>();
        for (v = 0; v < n; ++v) {
            if (!precGraph.getPredecessorsOf(v).isEmpty()) continue;
            queue.addLast(v);
        }
        while (!queue.isEmpty()) {
            v = (Integer)queue.removeFirst();
            ISetIterator iterator = precGraph.getPredecessorsOf(v).iterator();
            while (iterator.hasNext()) {
                int pre = iterator.nextInt();
                depth[v] = Math.max(depth[v], depth[pre] + 1);
            }
            iterator = precGraph.getSuccessorsOf(v).iterator();
            while (iterator.hasNext()) {
                int succ = iterator.nextInt();
                if (queue.contains(succ)) continue;
                queue.addLast(succ);
            }
        }
        return IntStream.range(0, n).boxed().sorted(Comparator.comparingInt(i -> depth[i])).mapToInt(i -> i).toArray();
    }

    public static FilterAllDiffPrec buildFilter(IntVar[] variables, boolean[][] precedence, String filt) {
        switch (filt) {
            case "BESSIERE": {
                return new AllDiffPrec(variables, precedence);
            }
            case "GREEDY": {
                return new GreedyBoundSupport(variables, precedence);
            }
            case "GREEDY_RC": {
                return new GreedyBoundSupport(variables, precedence, true);
            }
            case "GODET_RC": {
                return new AllDiffPrecMoreThanBc(variables, precedence, true);
            }
        }
        return new AllDiffPrecMoreThanBc(variables, precedence);
    }
}

