/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.renderer.generators.standard;

import java.awt.Font;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

final class TextOutline {
    public static final FontRenderContext FONT_RENDER_CONTEXT = new FontRenderContext(new AffineTransform(), true, true);
    private final String text;
    private final GlyphVector glyphs;
    private final Shape outline;
    private final AffineTransform transform;

    TextOutline(String text, Font font) {
        this(text, font.createGlyphVector(new FontRenderContext(new AffineTransform(), true, true), text));
    }

    TextOutline(String text, GlyphVector glyphs) {
        this(text, glyphs, glyphs.getOutline(), new AffineTransform());
    }

    private TextOutline(String text, GlyphVector glyphs, Shape outline, AffineTransform transform) {
        this.text = text;
        this.glyphs = glyphs;
        this.outline = outline;
        this.transform = transform;
    }

    String text() {
        return this.text;
    }

    Shape getOutline() {
        return this.transform.createTransformedShape(this.outline);
    }

    Rectangle2D getBounds() {
        return this.transformedBounds(this.outline);
    }

    Rectangle2D getLogicalBounds() {
        return this.transformedBounds(this.glyphs.getLogicalBounds());
    }

    private Rectangle2D transformedBounds(Shape shape) {
        Rectangle2D rectangle2D = shape.getBounds2D();
        Point2D.Double minPoint = new Point2D.Double(rectangle2D.getMinX(), rectangle2D.getMinY());
        Point2D.Double maxPoint = new Point2D.Double(rectangle2D.getMaxX(), rectangle2D.getMaxY());
        this.transform.transform(minPoint, minPoint);
        this.transform.transform(maxPoint, maxPoint);
        double minX = Math.min(((Point2D)minPoint).getX(), ((Point2D)maxPoint).getX());
        double maxX = Math.max(((Point2D)minPoint).getX(), ((Point2D)maxPoint).getX());
        double minY = Math.min(((Point2D)minPoint).getY(), ((Point2D)maxPoint).getY());
        double maxY = Math.max(((Point2D)minPoint).getY(), ((Point2D)maxPoint).getY());
        return new Rectangle2D.Double(minX, minY, maxX - minX, maxY - minY);
    }

    Point2D getCenter() {
        Rectangle2D bounds = this.getBounds();
        return new Point2D.Double(bounds.getCenterX(), bounds.getCenterY());
    }

    Point2D getFirstGlyphCenter() {
        return this.getGlyphCenter(0);
    }

    Point2D getLastGlyphCenter() {
        return this.getGlyphCenter(this.text.length() - 1);
    }

    private Point2D getGlyphCenter(int index) {
        if (this.text.length() == 1) {
            return this.getCenter();
        }
        Shape glyph = this.glyphs.getGlyphOutline(index);
        Rectangle2D glyphBounds = this.transformedBounds(glyph);
        return new Point2D.Double(glyphBounds.getCenterX(), glyphBounds.getCenterY());
    }

    TextOutline transform(AffineTransform nextTransform) {
        AffineTransform combinedTransform = new AffineTransform();
        combinedTransform.concatenate(nextTransform);
        combinedTransform.concatenate(this.transform);
        return new TextOutline(this.text, this.glyphs, this.outline, combinedTransform);
    }

    TextOutline resize(double scaleX, double scaleY) {
        Point2D center = this.getCenter();
        AffineTransform transform = new AffineTransform();
        transform.translate(center.getX(), center.getY());
        transform.scale(scaleX, scaleY);
        transform.translate(-center.getX(), -center.getY());
        return this.transform(transform);
    }

    TextOutline translate(double translateX, double translateY) {
        return this.transform(AffineTransform.getTranslateInstance(translateX, translateY));
    }

    public String toString() {
        Rectangle2D bounds = this.getBounds();
        StringBuilder sb = new StringBuilder(25);
        sb.append(this.text);
        sb.append(" [x=").append(TextOutline.formatDouble(bounds.getX()));
        sb.append(", y=").append(TextOutline.formatDouble(bounds.getY()));
        sb.append(", w=").append(TextOutline.formatDouble(bounds.getWidth()));
        sb.append(", h=").append(TextOutline.formatDouble(bounds.getHeight()));
        sb.append(']');
        return sb.toString();
    }

    static String formatDouble(double value) {
        return String.format("%.2f", value);
    }
}

