## ----include = FALSE----------------------------------------------------------
if (interactive()) {
  knitr::opts_chunk$set(
    collapse = TRUE,
    comment = "#>",
    root.dir = getwd()
  )
} else {
  knitr::opts_chunk$set(
    collapse = TRUE,
    comment = "#>",
    root.dir = tempdir()
  )
}
options(rmarkdown.html_vignette.check_title = FALSE)


## ----eval=FALSE---------------------------------------------------------------
# # Get the full path of an example NetCDF file from inst/extdata/testdata
# example_nc <- system.file("extdata", "testdata", "1960_1.nc", package = "rIACI")
# cat("Example NetCDF file path:", example_nc, "\n")
# 
# # Get the full path of an example CSV file from inst/extdata/testcsv
# example_csv <- system.file("extdata", "testcsv", "36.2_-5.6.csv", package = "rIACI")
# cat("Example CSV file path:", example_csv, "\n")

## ----eval=FALSE---------------------------------------------------------------
# # Install devtools if you haven't already
# install.packages("devtools")
# 
# # Install rIACI from GitHub
# devtools::install_github("https://github.com/Nan-Z-byte/rIACI")

## ----eval=FALSE---------------------------------------------------------------
# download_data(start_year, end_year,
#               start_month = 1,
#               end_month = 12,
#               variables = c("10m_u_component_of_wind",
#                             "10m_v_component_of_wind",
#                             "2m_temperature",
#                             "total_precipitation"),
#               dataset = "reanalysis-era5-land",
#               area = c(North, West, South, East),
#               output_dir = "cds_data",
#               user_id, user_key,
#               max_retries = 3,
#               retry_delay = 5,
#               timeout = 7200)
# 

## ----eval=FALSE---------------------------------------------------------------
# # Set your ECMWF user ID and key
# user_id <- "your_user_id"
# user_key <- "your_api_key"
# 
# # Define the geographical area (North, West, South, East)
# # Example: Iberian Peninsula roughly bounded by 44N, -10W, 35N, 5E
# area_iberia <- c(44, -10, 35, 5)
# 
# # Download data form the year 1960 to 2023
# download_data(
#   start_year = 1960,
#   end_year = 2023,
#   area = area_iberia,
#   user_id = user_id,
#   user_key = user_key
# )
# 

## ----eval=FALSE---------------------------------------------------------------
# process_data(input_dir, output_dir)

## ----eval=FALSE---------------------------------------------------------------
# input_directory <- "cds_data"
# output_directory <- "processed_data"
# 
# process_data(input_dir = input_directory, output_dir = output_directory)

## ----eval=FALSE---------------------------------------------------------------
# export_data_to_csv(nc_file, output_dir)

## ----eval=FALSE---------------------------------------------------------------
# netcdf_file <- "processed_data/2020_01.nc"
# csv_output_directory <- "csv_output"
# 
# export_data_to_csv(nc_file = netcdf_file, output_dir = csv_output_directory)
# 

## ----eval=FALSE---------------------------------------------------------------
# csv_to_netcdf(csv_dir, output_file)

## ----eval=FALSE---------------------------------------------------------------
# csv_directory <- "csv_output"
# output_netcdf_file <- "final_data/merged_data.nc"
# 
# csv_to_netcdf(csv_dir = csv_directory, output_file = output_netcdf_file)

## ----eval=FALSE---------------------------------------------------------------
# climate_input(tmax = NULL, tmin = NULL, prec = NULL, wind = NULL,
#               dates = NULL,base.range = c(1961, 1990), n = 5,
#               quantiles = NULL,
#               temp.qtiles = c(0.10, 0.90), wind.qtile = 0.90,
#               max.missing.days = c(annual = 15, monthly = 3),
#               min.base.data.fraction_present = 0.1)

## ----eval=FALSE---------------------------------------------------------------
# # Assume you have a CSV file with climate data
# climate_data <- read.csv("processed_data/climate_data.csv")
# 
# # Create climate input object
# ci <- climate_input(
#   tmax = climate_data$TMAX,
#   tmin = climate_data$TMIN,
#   prec = climate_data$PRCP,
#   wind = climate_data$WIND,
#   dates = as.Date(climate_data$DATE, format = "%Y-%m-%d")
# )
# 

## ----eval=FALSE---------------------------------------------------------------
# # Calculate monthly TX90p index
# tx90p_values <- tx90p(ci, freq = "monthly")
# 
# # View the results
# head(tx90p_values)
# 

## ----eval=FALSE---------------------------------------------------------------
# # Calculate standardized T90p index on a monthly basis
# t90p_std_values <- t90p_std(ci, freq = "monthly")
# 
# # View the results
# head(tx90p_std_values)
# 

## ----eval=FALSE---------------------------------------------------------------
# # Calculate seasonal TN10p index
# tx90p_seasonal <- monthly_to_seasonal(tx90p_values)
# 
# # View the results
# head(tx90p_seasonal)
# 

## ----eval=FALSE---------------------------------------------------------------
# sea_input(Date = levels(ci$date_factors$monthly), Value = NA)

## ----eval=FALSE---------------------------------------------------------------
# # Create sea level data
# sea_dates <- c("2020-01", "2020-02", "2020-03")
# sea_values <- c(1.2, 1.3, 1.4)
# 
# sea_data <- sea_input(Date = sea_dates, Value = sea_values)

## ----eval=FALSE---------------------------------------------------------------
# iaci_output(ci, si, freq = c("monthly", "seasonal"))

## ----eval=FALSE---------------------------------------------------------------
# # Generate IACI
# iaci <- iaci_output(ci, sea_data, freq = "monthly")
# 
# # View the IACI
# head(iaci)

## ----eval=FALSE---------------------------------------------------------------
# output_all(si, input_dir, output_dir, freq = c("monthly",
#                                                "seasonal"),
#            base.range = c(1961, 1990), time.span = c(1961, 2022))
# 

## ----eval=FALSE---------------------------------------------------------------
# # Define input and output directories
# input_dir <- "csv_output"
# output_dir <- "iaci_results"
# 
# # Run the output_all function with monthly frequency
# output_all(
#   si = sea_std_values,
#   input_dir = input_dir,
#   output_dir = output_dir,
#   freq = "monthly",
#   base.range = c(1961, 1990),
#   time.span = c(1961, 2022)
# )

## ----eval=FALSE---------------------------------------------------------------
# # Load the package
# library(rIACI)
# 
# # Step 1: Download ERA5-Land data
# user_id <- "your_user_id"
# user_key <- "your_api_key"
# area_iberia <- c(44, -10, 35, 5) # Approximate bounds of Iberian Peninsula
# 
# download_data(
#   start_year = 2020,
#   end_year = 2020,
#   variables = c("2m_temperature", "total_precipitation",
#                 "10m_u_component_of_wind", "10m_v_component_of_wind"),
#   area = area_iberia,
#   user_id = user_id,
#   user_key = user_key
# )
# 
# # Step 2: Process downloaded data
# input_directory <- "cds_data"
# output_directory <- "processed_data"
# 
# process_data(input_dir = input_directory, output_dir = output_directory)
# 
# # Step 3: Export processed NetCDF to CSV
# netcdf_file <- "processed_data/2020_01.nc"
# csv_output_directory <- "csv_output"
# 
# export_data_to_csv(nc_file = netcdf_file, output_dir = csv_output_directory)
# 
# # Step 4: Create climate input object
# climate_data <- read.csv("processed_data/climate_data.csv")
# ci <- climate_input(
#   tmax = climate_data$TMAX,
#   tmin = climate_data$TMIN,
#   prec = climate_data$PRCP,
#   wind = climate_data$WIND,
#   dates = as.Date(climate_data$DATE, format = "%Y-%m-%d")
# )
# 
# # Step 5: Integrate sea level data
# sea_dates <- c("2020-01", "2020-02", "2020-03")
# sea_values <- c(1.2, 1.3, 1.4)
# sea_data <- sea_input(Date = sea_dates, Value = sea_values)
# sea_std_values <- sea_std(sea_data, freq = "monthly")
# 
# # Step 6: Generate IACI
# iaci <- iaci_output(ci, sea_std_values, freq = "monthly")
# print(head(iaci))
# 
# # Step 7: Output all results
# output_all(
#   si = sea_std_values,
#   input_dir = csv_output_directory,
#   output_dir = "iaci_results",
#   freq = "monthly",
#   base.range = c(1961, 1990),
#   time.span = c(1961, 2022)
# )
# 
# # Step 8: Merge CSVs into NetCDF (optional)
# merged_netcdf <- "iaci.nc"
# csv_to_netcdf(csv_dir = iaci_results_directory, output_file = merged_netcdf)
# 

