/*
 * Decompiled with CFR 0.152.
 */
package com.qarks.util.ui.swing;

import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseMotionListener;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.ListSelectionModel;

public class OrderingList
extends JList {
    private int previousIndex = -1;
    protected DefaultListModel model = new DefaultListModel();
    private int[] selectedIndices;
    private MouseMotionListener mouseMotionListener;
    private MouseListener mouseListener;

    public OrderingList() {
        this.setModel(this.model);
        this.selectedIndices = new int[0];
        this.mouseListener = this.createMouseListener();
        this.mouseMotionListener = this.createMouseMotionListener();
        this.addMouseListener(this.mouseListener);
        this.addMouseMotionListener(this.mouseMotionListener);
    }

    @Override
    public void updateUI() {
        this.removeMouseListener(this.mouseListener);
        this.removeMouseMotionListener(this.mouseMotionListener);
        super.updateUI();
        this.addMouseListener(this.mouseListener);
        this.addMouseMotionListener(this.mouseMotionListener);
    }

    private MouseListener createMouseListener() {
        MouseAdapter mouseAdapter = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
            }

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                OrderingList.this.previousIndex = OrderingList.this.locationToIndex(new Point(mouseEvent.getX(), mouseEvent.getY()));
                OrderingList.access$102(OrderingList.this, OrderingList.this.getSelectedIndices());
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                if (!mouseEvent.isShiftDown() && !mouseEvent.isControlDown()) {
                    ListSelectionModel listSelectionModel = OrderingList.this.getSelectionModel();
                    listSelectionModel.clearSelection();
                    for (int i = 0; i < OrderingList.this.selectedIndices.length; ++i) {
                        listSelectionModel.addSelectionInterval(OrderingList.this.selectedIndices[i], OrderingList.this.selectedIndices[i]);
                    }
                }
            }
        };
        return mouseAdapter;
    }

    private MouseMotionListener createMouseMotionListener() {
        MouseMotionAdapter mouseMotionAdapter = new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent mouseEvent) {
                int n = OrderingList.this.locationToIndex(new Point(mouseEvent.getX(), mouseEvent.getY()));
                OrderingList.access$102(OrderingList.this, OrderingList.this.getSelectedIndices());
                if (OrderingList.this.selectedIndices.length > 0) {
                    int n2 = OrderingList.this.selectedIndices[OrderingList.this.selectedIndices.length - 1];
                    int n3 = OrderingList.this.selectedIndices[0];
                    int n4 = n - OrderingList.this.previousIndex;
                    ListSelectionModel listSelectionModel = OrderingList.this.getSelectionModel();
                    if (n4 > 0 && n2 + n4 < OrderingList.this.model.getSize()) {
                        listSelectionModel.clearSelection();
                        for (int i = OrderingList.this.selectedIndices.length - 1; i >= 0; --i) {
                            Object e = OrderingList.this.model.get(OrderingList.this.selectedIndices[i]);
                            OrderingList.this.model.remove(OrderingList.this.selectedIndices[i]);
                            OrderingList.this.model.add(OrderingList.this.selectedIndices[i] + n4, e);
                            listSelectionModel.addSelectionInterval(OrderingList.this.selectedIndices[i] + n4, OrderingList.this.selectedIndices[i] + n4);
                        }
                        OrderingList.this.previousIndex = n;
                        OrderingList.this.orderChanged();
                    } else if (n4 < 0 && n3 + n4 > -1) {
                        OrderingList.this.getSelectionModel().clearSelection();
                        for (int i = 0; i < OrderingList.this.selectedIndices.length; ++i) {
                            Object e = OrderingList.this.model.get(OrderingList.this.selectedIndices[i]);
                            OrderingList.this.model.remove(OrderingList.this.selectedIndices[i]);
                            OrderingList.this.model.add(OrderingList.this.selectedIndices[i] + n4, e);
                            listSelectionModel.addSelectionInterval(OrderingList.this.selectedIndices[i] + n4, OrderingList.this.selectedIndices[i] + n4);
                        }
                        OrderingList.this.previousIndex = n;
                        OrderingList.this.orderChanged();
                    }
                }
            }
        };
        return mouseMotionAdapter;
    }

    public void orderChanged() {
    }

    static /* synthetic */ int[] access$102(OrderingList orderingList, int[] nArray) {
        orderingList.selectedIndices = nArray;
        return nArray;
    }
}

