/*
 * Decompiled with CFR 0.152.
 */
package org.af.gMCP.gui.datatable;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.af.commons.widgets.tables.CloseTabPanel;
import org.af.commons.widgets.tables.DFPanelIF;
import org.af.gMCP.gui.datatable.CellEditorE;
import org.af.gMCP.gui.datatable.DataTable;
import org.af.gMCP.gui.datatable.RDataFrameRef;
import org.af.gMCP.gui.datatable.RowModel;
import org.af.gMCP.gui.graph.EdgeWeight;
import org.af.gMCP.gui.graph.GraphView;

public class DataFramePanel
extends JTabbedPane
implements ChangeListener,
ListSelectionListener,
DFPanelIF {
    private Vector<DataTable> tables = new Vector();
    private JScrollPane scrollPane;
    GraphView control;
    Vector<CellEditorE> defaultEditors = new Vector();
    int oldi = -1;
    int oldj = -1;
    int oldLayer = -1;

    public DataFramePanel(RDataFrameRef dfRefW) {
        this.addChangeListener(this);
        this.tables.add(new DataTable(dfRefW));
        this.addTab("Transition Matrix", this.getPanel(this.tables.get(0)));
    }

    private JPanel getPanel(DataTable table) {
        JPanel panel = new JPanel();
        table.getSelectionModel().addListSelectionListener(this);
        table.getColumnModel().getSelectionModel().addListSelectionListener(this);
        JTable rowHeader = new JTable(new RowModel(table.getModel()));
        rowHeader.setRowHeight(table.getRowHeight());
        this.scrollPane = new JScrollPane(table);
        this.scrollPane.setRowHeaderView(rowHeader);
        rowHeader.setPreferredScrollableViewportSize(rowHeader.getPreferredSize());
        String cols = "fill:pref:grow";
        String rows = "fill:pref:grow";
        FormLayout layout = new FormLayout(cols, rows);
        panel.setLayout((LayoutManager)layout);
        CellConstraints cc = new CellConstraints();
        panel.add((Component)this.scrollPane, cc.xy(1, 1));
        return panel;
    }

    public Vector<DataTable> getTable() {
        return this.tables;
    }

    public void addLayer() {
        RDataFrameRef dfRefW = new RDataFrameRef();
        DataTable dt = new DataTable(dfRefW);
        CellEditorE de = new CellEditorE(this.control, dt, this.tables.size());
        this.defaultEditors.add(de);
        dt.setDefaultEditor(EdgeWeight.class, de);
        for (String s : this.tables.get(0).getNames()) {
            dt.getModel().addRowCol(s);
        }
        this.tables.add(dt);
        this.setTitleAt(0, "Transition matrix 1");
        this.addTab("Transition matrix " + this.tables.size(), this.getPanel(dt));
        if (this.getTabCount() == 2) {
            this.setTabComponentAt(0, (Component)new CloseTabPanel((DFPanelIF)this));
        }
        this.setTabComponentAt(this.getTabCount() - 1, (Component)new CloseTabPanel((DFPanelIF)this));
    }

    public void removeLayer(int i) {
        int j;
        this.remove(i);
        this.tables.remove(i);
        this.defaultEditors.remove(i);
        this.control.removeEntangledLayer(i);
        if (this.getTabCount() == 1) {
            this.setTitleAt(0, "Transition matrix");
            this.setTabComponentAt(0, new JLabel("Transition matrix"));
        } else {
            for (j = 0; j < this.tables.size(); ++j) {
                this.setTitleAt(j, "Transition matrix " + (j + 1));
            }
        }
        for (j = i; j < this.tables.size(); ++j) {
            --this.defaultEditors.get((int)j).layer;
        }
    }

    public void renameNode(int i, String name) {
        for (DataTable dt : this.getTable()) {
            dt.renameNode(i, name);
        }
    }

    public void registerControl(GraphView control) {
        this.control = control;
        this.defaultEditors.removeAllElements();
        for (DataTable dt : this.getTable()) {
            CellEditorE de = new CellEditorE(control, dt, 0);
            this.defaultEditors.add(de);
            dt.setDefaultEditor(EdgeWeight.class, de);
        }
    }

    public void setTesting(boolean b) {
        for (DataTable dt : this.getTable()) {
            dt.setTesting(b);
        }
    }

    public void delRowCol(int node) {
        for (DataTable dt : this.getTable()) {
            dt.getModel().delRowCol(node);
        }
    }

    public void addRowCol(String name) {
        for (DataTable dt : this.getTable()) {
            dt.getModel().addRowCol(name);
        }
    }

    public void setValueAt(EdgeWeight value, int row, int col, int layer) {
        this.getTable().get(layer).getModel().setValueAt(value, row, col);
    }

    public void reset() {
        for (int i = this.tables.size() - 1; i > 0; --i) {
            this.tables.remove(i);
            this.remove(i);
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        int i = this.getSelectedIndex();
        if (this.control != null && this.control.getNL().getSelectedIndex() != 0) {
            this.control.getNL().setSelectedIndex(i + 1);
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        DataTable table = this.tables.get(this.getSelectedIndex());
        int i = table.getSelectedRow();
        int j = table.getSelectedColumn();
        int layer = this.getSelectedIndex();
        if (i != this.oldi || j != this.oldj) {
            this.control.getNL().highlightEdge(i, j, layer);
        }
        this.oldi = i;
        this.oldj = j;
        this.oldLayer = layer;
    }
}

