/*
 * Decompiled with CFR 0.152.
 */
package org.ohdsi.likelihood;

import dr.inference.model.AbstractModelLikelihood;
import dr.inference.model.Model;
import dr.inference.model.Parameter;
import dr.inference.model.Variable;
import org.apache.commons.math.util.FastMath;
import org.ohdsi.data.SortedCoxData;

public class CoxPartialLikelihood
extends AbstractModelLikelihood {
    private final Parameter beta;
    private final SortedCoxData data;
    private final int N;
    private final double numeratorConstant;
    private boolean likelihoodKnown;
    private boolean storedLikelihoodKnown;
    private double logLikelihood;
    private double storedLogLikelihood;

    public CoxPartialLikelihood(Parameter parameter, SortedCoxData sortedCoxData) {
        super("coxPartialLikelihood");
        this.beta = parameter;
        this.data = sortedCoxData;
        this.N = sortedCoxData.y.length;
        this.addVariable((Variable)parameter);
        int[] nArray = sortedCoxData.y;
        double[] dArray = sortedCoxData.x;
        double d = 0.0;
        for (int i = 0; i < this.N; ++i) {
            d += nArray[i] == 1 ? dArray[i] : 0.0;
        }
        this.numeratorConstant = d;
    }

    private double numeratorContribution() {
        return this.numeratorConstant * this.beta.getParameterValue(0);
    }

    private double denominatorContribution() {
        double[] dArray = this.data.weight;
        double[] dArray2 = this.data.x;
        int[] nArray = this.data.strata;
        double d = this.beta.getParameterValue(0);
        double d2 = 0.0;
        int n = 0;
        double d3 = 0.0;
        for (int i = 0; i < this.N; ++i) {
            if (i == nArray[n]) {
                d3 = 0.0;
                ++n;
            }
            double d4 = dArray[i] * FastMath.log((double)(d3 += FastMath.exp((double)(dArray2[i] * d))));
            d2 += d4;
        }
        return d2;
    }

    private double calculateLogLikelihood() {
        return this.numeratorContribution() - this.denominatorContribution();
    }

    protected void handleModelChangedEvent(Model model, Object object, int n) {
    }

    protected void handleVariableChangedEvent(Variable variable, int n, Variable.ChangeType changeType) {
        if (variable == this.beta) {
            this.likelihoodKnown = false;
        }
    }

    protected void storeState() {
        this.storedLikelihoodKnown = this.likelihoodKnown;
        this.storedLogLikelihood = this.logLikelihood;
    }

    protected void restoreState() {
        this.likelihoodKnown = this.storedLikelihoodKnown;
        this.logLikelihood = this.storedLogLikelihood;
    }

    protected void acceptState() {
    }

    public Model getModel() {
        return this;
    }

    public double getLogLikelihood() {
        if (!this.likelihoodKnown) {
            this.logLikelihood = this.calculateLogLikelihood();
            this.likelihoodKnown = true;
        }
        return this.logLikelihood;
    }

    public void makeDirty() {
        this.likelihoodKnown = false;
    }

    public static void main(String[] stringArray) {
        int[] nArray = new int[]{1, 1, 0, 1, 0, 1, 1};
        double[] dArray = new double[]{1.0, 1.0, 0.0, 1.0, 0.0, 1.0, 1.0};
        double[] dArray2 = new double[]{0.0, 2.0, 1.0, 1.0, 0.0, 0.0, 1.0};
        int[] nArray2 = new int[]{4, 7};
        double d = 1.205852;
        SortedCoxData sortedCoxData = new SortedCoxData(nArray, dArray2, nArray2, dArray);
        Parameter.Default default_ = new Parameter.Default(d);
        CoxPartialLikelihood coxPartialLikelihood = new CoxPartialLikelihood((Parameter)default_, sortedCoxData);
        System.err.println(coxPartialLikelihood.getLogLikelihood());
    }
}

