/*
 * Decompiled with CFR 0.152.
 */
package org.ohdsi.data;

import dr.inference.model.Parameter;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.ohdsi.data.SortedCoxData;
import org.ohdsi.likelihood.CoxPartialLikelihood;

public class CoxData {
    private final SortedCoxData data;

    public CoxData(int[] nArray, double[] dArray, double[] dArray2) {
        this(null, nArray, dArray, dArray2);
    }

    public CoxData(int[] nArray, int[] nArray2, double[] dArray, double[] dArray2) {
        if (nArray2.length != dArray.length || nArray2.length != dArray2.length || nArray != null && nArray.length != nArray2.length) {
            throw new IllegalArgumentException("All dimensions must be equal");
        }
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (int i = 0; i < nArray2.length; ++i) {
            arrayList.add(i);
        }
        arrayList.sort(Comparator.comparing(n -> nArray2[n]));
        arrayList.sort(Comparator.comparing(n -> -dArray[n]));
        if (nArray != null) {
            arrayList.sort(Comparator.comparing(n -> nArray2[n]));
        }
        int[] nArray3 = this.getInt(arrayList, nArray2);
        double[] dArray3 = this.getDouble(arrayList, dArray2);
        int[] nArray4 = this.getInt(arrayList, nArray);
        double[] dArray4 = this.getDouble(arrayList, dArray);
        double[] dArray5 = this.getWeights(nArray3, nArray4, dArray4);
        this.data = new SortedCoxData(nArray3, dArray3, this.getStrata(nArray4, nArray3.length), dArray5);
    }

    public SortedCoxData getSortedData() {
        return this.data;
    }

    private boolean isFailureTie(int[] nArray, double[] dArray, int[] nArray2, int n) {
        boolean bl;
        boolean bl2 = bl = nArray[n] == 1 && nArray[n + 1] == 1 && dArray[n] == dArray[n + 1];
        if (nArray2 != null) {
            bl = bl && nArray2[n] == nArray2[n + 1];
        }
        return bl;
    }

    private double[] getWeights(int[] nArray, int[] nArray2, double[] dArray) {
        double[] dArray2 = new double[nArray.length];
        double d = 1.0;
        for (int i = 0; i < nArray.length - 1; ++i) {
            if (this.isFailureTie(nArray, dArray, nArray2, i)) {
                d += 1.0;
                dArray2[i] = 0.0;
                continue;
            }
            dArray2[i] = nArray[i] == 1 ? d : 0.0;
            d = 1.0;
        }
        dArray2[nArray.length - 1] = nArray[nArray.length - 1] == 1 ? d : 0.0;
        return dArray2;
    }

    private int[] getInt(List<Integer> list, int[] nArray) {
        if (nArray == null) {
            return null;
        }
        int[] nArray2 = new int[nArray.length];
        for (int i = 0; i < nArray2.length; ++i) {
            nArray2[i] = nArray[list.get(i)];
        }
        return nArray2;
    }

    private double[] getDouble(List<Integer> list, double[] dArray) {
        double[] dArray2 = new double[dArray.length];
        for (int i = 0; i < dArray2.length; ++i) {
            dArray2[i] = dArray[list.get(i)];
        }
        return dArray2;
    }

    private int[] getStrata(int[] nArray, int n2) {
        int n3;
        if (nArray == null) {
            return new int[]{n2};
        }
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        int n4 = nArray[0];
        for (n3 = 1; n3 < nArray.length; ++n3) {
            int n5 = nArray[n3];
            if (n5 == n4) continue;
            arrayList.add(n3);
            n4 = n5;
        }
        arrayList.add(n3);
        return arrayList.stream().mapToInt(n -> n).toArray();
    }

    public static void main(String[] stringArray) {
        int[] nArray = new int[]{1, 1, 0, 1, 1, 0, 1};
        double[] dArray = new double[]{4.0, 3.0, 3.0, 2.0, 2.0, 1.0, 1.0};
        double[] dArray2 = new double[]{0.0, 2.0, 0.0, 0.0, 1.0, 1.0, 1.0};
        int[] nArray2 = new int[]{0, 0, 1, 1, 1, 0, 0};
        double d = 0.7357498;
        CoxData coxData = new CoxData(nArray2, nArray, dArray, dArray2);
        Parameter.Default default_ = new Parameter.Default(d);
        CoxPartialLikelihood coxPartialLikelihood = new CoxPartialLikelihood((Parameter)default_, coxData.getSortedData());
        System.err.println(coxPartialLikelihood.getLogLikelihood());
    }
}

