/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.ns;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.zip.DataFormatException;
import oracle.net.ns.NIOPacket;
import oracle.net.ns.NetException;
import oracle.net.ns.SessionAtts;

public class NIONSDataChannel
extends NIOPacket {
    int sessionIdSize;
    protected byte[] compressedDataBuffer;
    protected byte[] decompressedDataBuffer;

    public NIONSDataChannel(SessionAtts sessionAtts) {
        super(sessionAtts);
        this.header.type = 6;
        this.sessionIdSize = sessionAtts.poolEnabled ? 16 : 0;
    }

    public int getDataExpansionByteSize() {
        return 0;
    }

    public void readDataFromSocketChannel() throws IOException {
        if (this.session.dataEOF) {
            throw new NetException(202);
        }
        this.session.payloadDataBufferForRead.position(this.session.payloadDataBufferForRead.limit());
        this.readFromSocketChannel(true);
        short s2 = this.session.payloadBufferForRead.getShort();
        this.session.payloadDataBufferForRead = this.session.payloadBufferForRead.slice();
        this.session.payloadDataBufferForRead.order(this.session.getByteOrder());
        this.session.payloadDataBufferForRead.limit(this.session.payloadBufferForRead.limit() - 2);
        if ((s2 & 0x40) != 0) {
            this.session.dataEOF = true;
        }
        if ((s2 & 0x400) != 0) {
            try {
                this.session.payloadDataBufferForRead.get(this.compressedDataBuffer, 0, this.session.payloadDataBufferForRead.limit());
                int n2 = this.session.compressionCodec.decompress(this.compressedDataBuffer, 0, this.session.payloadDataBufferForRead.limit(), this.decompressedDataBuffer);
                this.session.payloadDataBufferForRead = ByteBuffer.wrap(this.decompressedDataBuffer, 0, n2);
                this.session.payloadDataBufferForRead.order(this.session.getByteOrder());
                this.session.payloadDataBufferForRead.limit(n2);
            }
            catch (DataFormatException dataFormatException) {
                throw (IOException)new IOException("Network Compression failure").initCause(dataFormatException);
            }
        }
    }

    public void sendEOF() throws IOException {
        this.session.prepareWriteBuffer();
        this.session.payloadBufferForWrite.put((byte)0);
        this.session.payloadBufferForWrite.put((byte)64);
        this.writeToSocketChannel();
    }

    public void writeDataToSocketChannel() throws IOException {
        this.writeDataToSocketChannel(0);
    }

    public void writeDataToSocketChannel(int n2) throws IOException {
        if (this.session.payloadDataBufferForWrite.position() > 0) {
            this.session.payloadBufferForWrite.clear();
            this.header.type = 6;
            if (this.session.networkCompressionEnabled && this.session.payloadDataBufferForWrite.position() + 10 > this.session.networkCompressionThreshold) {
                try {
                    int n3;
                    int n4 = this.session.payloadDataBufferForWrite.position();
                    if (this.session.writeBuffer.hasArray()) {
                        n3 = this.session.compressionCodec.compress(this.session.writeBuffer.array(), 10, n4, this.compressedDataBuffer);
                    } else {
                        this.session.payloadDataBufferForWrite.rewind();
                        this.session.payloadDataBufferForWrite.get(this.decompressedDataBuffer, 0, n4);
                        n3 = this.session.compressionCodec.compress(this.decompressedDataBuffer, 0, n4, this.compressedDataBuffer);
                    }
                    if (n3 < n4) {
                        n2 |= 0x400;
                        this.session.payloadDataBufferForWrite.rewind();
                        this.session.payloadDataBufferForWrite.put(this.compressedDataBuffer, 0, n3);
                    }
                }
                catch (DataFormatException dataFormatException) {
                    throw (IOException)new IOException("Network Compression failure").initCause(dataFormatException);
                }
            }
            this.session.payloadBufferForWrite.position(this.session.payloadDataBufferForWrite.position() + 2);
            this.session.payloadBufferForWrite.put(0, (byte)(n2 / 256));
            this.session.payloadBufferForWrite.put(1, (byte)(n2 % 256));
            this.writeToSocketChannel();
        }
    }

    public ByteBuffer getDataBuffer() {
        return this.session.payloadDataBufferForRead;
    }

    void initializeNetworkCompressionBuffers() {
        this.compressedDataBuffer = new byte[this.session.getSDU()];
        this.decompressedDataBuffer = new byte[this.session.getSDU()];
    }

    byte[] readPayloadDataFromSocketChannel(int n2) throws IOException {
        byte[] byArray = new byte[n2];
        int n3 = 0;
        for (int i2 = 0; i2 < n2; i2 += n3) {
            this.readDataFromSocketChannel();
            n3 = this.session.payloadDataBufferForRead.limit();
            this.session.payloadDataBufferForRead.get(byArray, i2, n3);
        }
        return byArray;
    }

    void writeDataToSocketChannel(byte[] byArray) throws IOException {
        int n2 = 0;
        int n3 = 0;
        for (int i2 = 0; i2 < byArray.length; i2 += n2) {
            this.session.prepareWriteBuffer();
            n2 = this.session.payloadDataBufferForWrite.limit() - this.session.payloadDataBufferForWrite.position();
            if (n2 > byArray.length - i2) {
                n2 = byArray.length - i2;
            }
            n3 = byArray.length > n2 ? 32 : 0;
            this.session.payloadDataBufferForWrite.put(byArray, i2, n2);
            this.writeDataToSocketChannel(n3);
        }
    }

    @Override
    void readPayloadBuffer() throws IOException {
        throw new UnsupportedOperationException("Data Byte buffers are not duplicated and accessed directly by the upper layer");
    }
}

