/*
 * Decompiled with CFR 0.152.
 */
package choR;

import core.explorer.ChordalysisModeller;
import core.explorer.ChordalysisModellingBudget;
import core.explorer.ChordalysisModellingMML;
import core.explorer.ChordalysisModellingSMT;
import core.graph.ChordalGraph;
import core.model.DecomposableModel;
import java.util.BitSet;
import java.util.List;
import loader.LoadArrays;

public final class ChoR {
    public static String ChordalysisModellingBudget(int[] nArray, int[][] nArray2, double d, double d2) {
        ChordalysisModeller.Data data = LoadArrays.makeModelData(nArray, nArray2);
        ChordalysisModellingBudget chordalysisModellingBudget = new ChordalysisModellingBudget(data, d, d2);
        chordalysisModellingBudget.buildModel();
        return ChoR.getFormulaString(chordalysisModellingBudget.getModel());
    }

    public static String ChordalysisModellingMML(int[] nArray, int[][] nArray2) {
        ChordalysisModeller.Data data = LoadArrays.makeModelData(nArray, nArray2);
        ChordalysisModellingMML chordalysisModellingMML = new ChordalysisModellingMML(data);
        chordalysisModellingMML.buildModel();
        return ChoR.getFormulaString(chordalysisModellingMML.getModel());
    }

    public static String ChordalysisModellingSMT(int[] nArray, int[][] nArray2, double d) {
        ChordalysisModeller.Data data = LoadArrays.makeModelData(nArray, nArray2);
        ChordalysisModellingSMT chordalysisModellingSMT = new ChordalysisModellingSMT(data, d);
        chordalysisModellingSMT.buildModel();
        return ChoR.getFormulaString(chordalysisModellingSMT.getModel());
    }

    private static String getFormulaString(DecomposableModel decomposableModel) {
        ChordalGraph chordalGraph = decomposableModel.graph;
        List<BitSet> list = chordalGraph.getCliquesBFS();
        String string = "~";
        for (BitSet bitSet : list) {
            int n = bitSet.nextSetBit(0);
            while (n >= 0) {
                string = string + n + "*";
                n = bitSet.nextSetBit(n + 1);
            }
            if (string.endsWith("*")) {
                string = string.substring(0, string.length() - 1);
            }
            string = string + "+";
        }
        if (string.endsWith("+")) {
            string = string.substring(0, string.length() - 1);
        }
        return string;
    }
}

