/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.bayes.net.estimate;

import java.util.Enumeration;
import java.util.Vector;
import weka.classifiers.bayes.BayesNet;
import weka.classifiers.bayes.net.estimate.DiscreteEstimatorBayes;
import weka.classifiers.bayes.net.estimate.DiscreteEstimatorFullBayes;
import weka.classifiers.bayes.net.estimate.SimpleEstimator;
import weka.classifiers.bayes.net.search.local.K2;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.RevisionUtils;
import weka.core.Statistics;
import weka.core.Utils;
import weka.estimators.Estimator;

public class BMAEstimator
extends SimpleEstimator {
    static final long serialVersionUID = -1846028304233257309L;
    protected boolean m_bUseK2Prior = false;

    @Override
    public String globalInfo() {
        return "BMAEstimator estimates conditional probability tables of a Bayes network using Bayes Model Averaging (BMA).";
    }

    @Override
    public void estimateCPTs(BayesNet bayesNet) throws Exception {
        this.initCPTs(bayesNet);
        Instances instances = bayesNet.m_Instances;
        int iAttribute = 0;
        while (iAttribute < instances.numAttributes()) {
            if (bayesNet.getParentSet(iAttribute).getNrOfParents() > 1) {
                throw new Exception("Cannot handle networks with nodes with more than 1 parent (yet).");
            }
            ++iAttribute;
        }
        BayesNet EmptyNet = new BayesNet();
        K2 oSearchAlgorithm = new K2();
        oSearchAlgorithm.setInitAsNaiveBayes(false);
        oSearchAlgorithm.setMaxNrOfParents(0);
        EmptyNet.setSearchAlgorithm(oSearchAlgorithm);
        EmptyNet.buildClassifier(instances);
        BayesNet NBNet = new BayesNet();
        oSearchAlgorithm.setInitAsNaiveBayes(true);
        oSearchAlgorithm.setMaxNrOfParents(1);
        NBNet.setSearchAlgorithm(oSearchAlgorithm);
        NBNet.buildClassifier(instances);
        int iAttribute2 = 0;
        while (iAttribute2 < instances.numAttributes()) {
            if (iAttribute2 != instances.classIndex()) {
                int iParent;
                int iAttValue;
                double w1 = 0.0;
                double w2 = 0.0;
                int nAttValues = instances.attribute(iAttribute2).numValues();
                if (this.m_bUseK2Prior) {
                    iAttValue = 0;
                    while (iAttValue < nAttValues) {
                        w1 += Statistics.lnGamma(1.0 + ((DiscreteEstimatorBayes)EmptyNet.m_Distributions[iAttribute2][0]).getCount(iAttValue)) - Statistics.lnGamma(1.0);
                        ++iAttValue;
                    }
                    w1 += Statistics.lnGamma(nAttValues) - Statistics.lnGamma(nAttValues + instances.numInstances());
                    iParent = 0;
                    while (iParent < bayesNet.getParentSet(iAttribute2).getCardinalityOfParents()) {
                        int nTotal = 0;
                        int iAttValue2 = 0;
                        while (iAttValue2 < nAttValues) {
                            double nCount = ((DiscreteEstimatorBayes)NBNet.m_Distributions[iAttribute2][iParent]).getCount(iAttValue2);
                            w2 += Statistics.lnGamma(1.0 + nCount) - Statistics.lnGamma(1.0);
                            nTotal = (int)((double)nTotal + nCount);
                            ++iAttValue2;
                        }
                        w2 += Statistics.lnGamma(nAttValues) - Statistics.lnGamma(nAttValues + nTotal);
                        ++iParent;
                    }
                } else {
                    iAttValue = 0;
                    while (iAttValue < nAttValues) {
                        w1 += Statistics.lnGamma(1.0 / (double)nAttValues + ((DiscreteEstimatorBayes)EmptyNet.m_Distributions[iAttribute2][0]).getCount(iAttValue)) - Statistics.lnGamma(1.0 / (double)nAttValues);
                        ++iAttValue;
                    }
                    w1 += Statistics.lnGamma(1.0) - Statistics.lnGamma(1 + instances.numInstances());
                    int nParentValues = bayesNet.getParentSet(iAttribute2).getCardinalityOfParents();
                    int iParent2 = 0;
                    while (iParent2 < nParentValues) {
                        int nTotal = 0;
                        int iAttValue3 = 0;
                        while (iAttValue3 < nAttValues) {
                            double nCount = ((DiscreteEstimatorBayes)NBNet.m_Distributions[iAttribute2][iParent2]).getCount(iAttValue3);
                            w2 += Statistics.lnGamma(1.0 / (double)(nAttValues * nParentValues) + nCount) - Statistics.lnGamma(1.0 / (double)(nAttValues * nParentValues));
                            nTotal = (int)((double)nTotal + nCount);
                            ++iAttValue3;
                        }
                        w2 += Statistics.lnGamma(1.0) - Statistics.lnGamma(1 + nTotal);
                        ++iParent2;
                    }
                }
                if (w1 < w2) {
                    w2 -= w1;
                    w1 = 0.0;
                    w1 = 1.0 / (1.0 + Math.exp(w2));
                    w2 = Math.exp(w2) / (1.0 + Math.exp(w2));
                } else {
                    w1 -= w2;
                    w2 = 0.0;
                    w2 = 1.0 / (1.0 + Math.exp(w1));
                    w1 = Math.exp(w1) / (1.0 + Math.exp(w1));
                }
                iParent = 0;
                while (iParent < bayesNet.getParentSet(iAttribute2).getCardinalityOfParents()) {
                    bayesNet.m_Distributions[iAttribute2][iParent] = new DiscreteEstimatorFullBayes(instances.attribute(iAttribute2).numValues(), w1, w2, (DiscreteEstimatorBayes)EmptyNet.m_Distributions[iAttribute2][0], (DiscreteEstimatorBayes)NBNet.m_Distributions[iAttribute2][iParent], this.m_fAlpha);
                    ++iParent;
                }
            }
            ++iAttribute2;
        }
        iAttribute2 = instances.classIndex();
        bayesNet.m_Distributions[iAttribute2][0] = EmptyNet.m_Distributions[iAttribute2][0];
    }

    @Override
    public void updateClassifier(BayesNet bayesNet, Instance instance) throws Exception {
        throw new Exception("updateClassifier does not apply to BMA estimator");
    }

    @Override
    public void initCPTs(BayesNet bayesNet) throws Exception {
        int nMaxParentCardinality = 1;
        int iAttribute = 0;
        while (iAttribute < bayesNet.m_Instances.numAttributes()) {
            if (bayesNet.getParentSet(iAttribute).getCardinalityOfParents() > nMaxParentCardinality) {
                nMaxParentCardinality = bayesNet.getParentSet(iAttribute).getCardinalityOfParents();
            }
            ++iAttribute;
        }
        bayesNet.m_Distributions = new Estimator[bayesNet.m_Instances.numAttributes()][nMaxParentCardinality];
    }

    public boolean isUseK2Prior() {
        return this.m_bUseK2Prior;
    }

    public void setUseK2Prior(boolean bUseK2Prior) {
        this.m_bUseK2Prior = bUseK2Prior;
    }

    @Override
    public Enumeration listOptions() {
        Vector<Option> newVector = new Vector<Option>(1);
        newVector.addElement(new Option("\tWhether to use K2 prior.\n", "k2", 0, "-k2"));
        Enumeration enu = super.listOptions();
        while (enu.hasMoreElements()) {
            newVector.addElement((Option)enu.nextElement());
        }
        return newVector.elements();
    }

    @Override
    public void setOptions(String[] options) throws Exception {
        this.setUseK2Prior(Utils.getFlag("k2", options));
        super.setOptions(options);
    }

    @Override
    public String[] getOptions() {
        String[] superOptions = super.getOptions();
        String[] options = new String[1 + superOptions.length];
        int current = 0;
        if (this.isUseK2Prior()) {
            options[current++] = "-k2";
        }
        int iOption = 0;
        while (iOption < superOptions.length) {
            options[current++] = superOptions[iOption];
            ++iOption;
        }
        while (current < options.length) {
            options[current++] = "";
        }
        return options;
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 1.8 $");
    }
}

