/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.geometry.cip;

import org.openscience.cdk.geometry.cip.ILigand;
import org.openscience.cdk.geometry.cip.ImplicitHydrogenLigand;
import org.openscience.cdk.geometry.cip.Ligand;
import org.openscience.cdk.geometry.cip.VisitedAtoms;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.ITetrahedralChirality;

class LigancyFourChirality {
    private final IAtom chiralAtom;
    private final ILigand[] ligands;
    private final ITetrahedralChirality.Stereo stereo;

    public LigancyFourChirality(IAtom chiralAtom, ILigand[] ligands, ITetrahedralChirality.Stereo stereo) {
        this.chiralAtom = chiralAtom;
        this.ligands = ligands;
        this.stereo = stereo;
    }

    public LigancyFourChirality(IAtomContainer container, ITetrahedralChirality cdkChirality) {
        this.chiralAtom = cdkChirality.getChiralAtom();
        IAtom[] ligandAtoms = cdkChirality.getLigands();
        this.ligands = new ILigand[ligandAtoms.length];
        VisitedAtoms visitedAtoms = new VisitedAtoms();
        for (int i = 0; i < ligandAtoms.length; ++i) {
            this.ligands[i] = ligandAtoms[i].equals(this.chiralAtom) ? new ImplicitHydrogenLigand(container, visitedAtoms, this.chiralAtom) : new Ligand(container, visitedAtoms, this.chiralAtom, ligandAtoms[i]);
        }
        this.stereo = cdkChirality.getStereo();
    }

    public ILigand[] getLigands() {
        return this.ligands;
    }

    public IAtom getChiralAtom() {
        return this.chiralAtom;
    }

    public ITetrahedralChirality.Stereo getStereo() {
        return this.stereo;
    }

    public LigancyFourChirality project(ILigand[] newOrder) {
        ITetrahedralChirality.Stereo newStereo = this.stereo;
        ILigand[] newAtoms = new ILigand[4];
        System.arraycopy(this.ligands, 0, newAtoms, 0, 4);
        for (int i = 0; i < 3; ++i) {
            if (newAtoms[i].getLigandAtom().equals(newOrder[i].getLigandAtom())) continue;
            for (int j = i; j < 4; ++j) {
                if (!newAtoms[j].getLigandAtom().equals(newOrder[i].getLigandAtom())) continue;
                this.swap(newAtoms, i, j);
                newStereo = newStereo == ITetrahedralChirality.Stereo.CLOCKWISE ? ITetrahedralChirality.Stereo.ANTI_CLOCKWISE : ITetrahedralChirality.Stereo.CLOCKWISE;
            }
        }
        return new LigancyFourChirality(this.chiralAtom, newAtoms, newStereo);
    }

    private void swap(ILigand[] ligands, int first, int second) {
        ILigand tmpLigand = ligands[first];
        ligands[first] = ligands[second];
        ligands[second] = tmpLigand;
    }
}

