/*
 * Decompiled with CFR 0.152.
 */
package com.qarks.util.stream;

import com.qarks.util.stream.StreamCopyListener;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class StreamHelper {
    private InputStream mInputStream = null;
    private OutputStream mOutputStream = null;
    private int mBufferSize = -1;
    private byte[] mByteBuffer = null;
    private static final int DEFAULT_BUFFER_SIZE = 51200;

    public StreamHelper() {
        this.setBufferSize(51200);
    }

    public int getBufferSize() {
        return this.mBufferSize;
    }

    public void setBufferSize(int n) {
        if (this.mBufferSize != n) {
            this.mBufferSize = n;
            this.mByteBuffer = new byte[this.mBufferSize];
        }
    }

    public void setCopyStreams(InputStream inputStream, OutputStream outputStream) {
        this.mInputStream = inputStream;
        this.mOutputStream = outputStream;
    }

    public void doCopy(File file, InputStream inputStream, OutputStream outputStream, StreamCopyListener streamCopyListener) throws IOException {
        this.setCopyStreams(inputStream, outputStream);
        long l = file.length();
        int n = 0;
        try {
            int n2 = 0;
            while (n2 > -1) {
                n2 = this.mInputStream.read(this.mByteBuffer, 0, this.mBufferSize);
                if (n2 > 0) {
                    if ((long)n == l && streamCopyListener != null) {
                        streamCopyListener.onFileCopyEnding(file);
                    }
                    this.mOutputStream.write(this.mByteBuffer, 0, n2);
                    n += n2;
                    if (streamCopyListener == null) continue;
                    streamCopyListener.onLengthChanged(n2);
                    continue;
                }
                if (n2 != 0) continue;
                Thread.sleep(50L);
            }
            if (streamCopyListener != null) {
                streamCopyListener.onFileCopyEnded(file);
            }
        }
        catch (IOException iOException) {
            throw iOException;
        }
        catch (Exception exception) {
            throw new IOException(exception.getMessage());
        }
    }
}

