/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.util.model;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import opennlp.tools.util.BaseToolFactory;
import opennlp.tools.util.InvalidFormatException;
import opennlp.tools.util.Version;
import opennlp.tools.util.ext.ExtensionLoader;
import opennlp.tools.util.model.ArtifactProvider;
import opennlp.tools.util.model.ArtifactSerializer;
import opennlp.tools.util.model.DictionarySerializer;
import opennlp.tools.util.model.GenericModelSerializer;
import opennlp.tools.util.model.PropertiesSerializer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseModel
implements ArtifactProvider {
    protected static final String MANIFEST_ENTRY = "manifest.properties";
    protected static final String FACTORY_NAME = "factory";
    private static final String MANIFEST_VERSION_PROPERTY = "Manifest-Version";
    private static final String COMPONENT_NAME_PROPERTY = "Component-Name";
    private static final String VERSION_PROPERTY = "OpenNLP-Version";
    private static final String TIMESTAMP_PROPERTY = "Timestamp";
    private static final String LANGUAGE_PROPERTY = "Language";
    public static final String TRAINING_CUTOFF_PROPERTY = "Training-Cutoff";
    public static final String TRAINING_ITERATIONS_PROPERTY = "Training-Iterations";
    public static final String TRAINING_EVENTHASH_PROPERTY = "Training-Eventhash";
    private Map<String, ArtifactSerializer> artifactSerializers = new HashMap<String, ArtifactSerializer>();
    protected final Map<String, Object> artifactMap = new HashMap<String, Object>();
    protected BaseToolFactory toolFactory;
    private final String componentName;
    private Map<String, byte[]> leftoverArtifacts;
    private boolean subclassSerializersInitiated = false;
    private boolean finishedLoadingArtifacts = false;
    private final boolean isLoadedFromSerialized;

    private BaseModel(String componentName, boolean isLoadedFromSerialized) {
        this.isLoadedFromSerialized = isLoadedFromSerialized;
        if (componentName == null) {
            throw new IllegalArgumentException("componentName must not be null!");
        }
        this.componentName = componentName;
    }

    protected BaseModel(String componentName, String languageCode, Map<String, String> manifestInfoEntries, BaseToolFactory factory) {
        this(componentName, false);
        if (languageCode == null) {
            throw new IllegalArgumentException("languageCode must not be null!");
        }
        this.createBaseArtifactSerializers(this.artifactSerializers);
        Properties manifest = new Properties();
        manifest.setProperty(MANIFEST_VERSION_PROPERTY, "1.0");
        manifest.setProperty(LANGUAGE_PROPERTY, languageCode);
        manifest.setProperty(VERSION_PROPERTY, Version.currentVersion().toString());
        manifest.setProperty(TIMESTAMP_PROPERTY, Long.toString(System.currentTimeMillis()));
        manifest.setProperty(COMPONENT_NAME_PROPERTY, componentName);
        if (manifestInfoEntries != null) {
            for (Map.Entry<String, String> entry : manifestInfoEntries.entrySet()) {
                manifest.setProperty(entry.getKey(), entry.getValue());
            }
        }
        this.artifactMap.put(MANIFEST_ENTRY, manifest);
        this.finishedLoadingArtifacts = true;
        if (factory != null) {
            this.setManifestProperty(FACTORY_NAME, factory.getClass().getCanonicalName());
            this.artifactMap.putAll(factory.createArtifactMap());
            Map<String, String> entries = factory.createManifestEntries();
            for (String key : entries.keySet()) {
                this.setManifestProperty(key, entries.get(key));
            }
        }
        try {
            this.initializeFactory();
        }
        catch (InvalidFormatException e) {
            throw new IllegalArgumentException("Could not initialize tool factory. ", e);
        }
        this.loadArtifactSerializers();
    }

    protected BaseModel(String componentName, String languageCode, Map<String, String> manifestInfoEntries) {
        this(componentName, languageCode, manifestInfoEntries, null);
    }

    protected BaseModel(String componentName, InputStream in) throws IOException, InvalidFormatException {
        this(componentName, true);
        if (in == null) {
            throw new IllegalArgumentException("in must not be null!");
        }
        this.loadModel(in);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected BaseModel(String componentName, File modelFile) throws IOException, InvalidFormatException {
        this(componentName, true);
        BufferedInputStream in = new BufferedInputStream(new FileInputStream(modelFile));
        try {
            this.loadModel(in);
        }
        finally {
            ((InputStream)in).close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected BaseModel(String componentName, URL modelURL) throws IOException, InvalidFormatException {
        this(componentName, true);
        InputStream in = modelURL.openStream();
        try {
            this.loadModel(in);
        }
        finally {
            in.close();
        }
    }

    private void loadModel(InputStream in) throws IOException, InvalidFormatException {
        ZipEntry entry;
        this.createBaseArtifactSerializers(this.artifactSerializers);
        ZipInputStream zip = new ZipInputStream(in);
        this.leftoverArtifacts = new HashMap<String, byte[]>();
        while ((entry = zip.getNextEntry()) != null) {
            String extension = this.getEntryExtension(entry.getName());
            ArtifactSerializer factory = this.artifactSerializers.get(extension);
            if (factory == null) {
                byte[] bytes = BaseModel.toByteArray(zip);
                this.leftoverArtifacts.put(entry.getName(), bytes);
            } else {
                this.artifactMap.put(entry.getName(), factory.create(zip));
            }
            zip.closeEntry();
        }
        this.initializeFactory();
        this.loadArtifactSerializers();
        this.finishLoadingArtifacts();
        this.checkArtifactMap();
    }

    private void initializeFactory() throws InvalidFormatException {
        String factoryName = this.getManifestProperty(FACTORY_NAME);
        if (factoryName == null) {
            Class<? extends BaseToolFactory> factoryClass = this.getDefaultFactory();
            if (factoryClass != null) {
                this.toolFactory = BaseToolFactory.create(factoryClass, (ArtifactProvider)this);
            }
        } else {
            try {
                this.toolFactory = BaseToolFactory.create(factoryName, (ArtifactProvider)this);
            }
            catch (InvalidFormatException e) {
                throw new IllegalArgumentException(e);
            }
        }
    }

    protected Class<? extends BaseToolFactory> getDefaultFactory() {
        return null;
    }

    private void loadArtifactSerializers() {
        if (!this.subclassSerializersInitiated) {
            this.createArtifactSerializers(this.artifactSerializers);
        }
        this.subclassSerializersInitiated = true;
    }

    private void finishLoadingArtifacts() throws InvalidFormatException, IOException {
        this.finishedLoadingArtifacts = true;
        if (this.leftoverArtifacts == null || this.leftoverArtifacts.size() == 0) {
            return;
        }
        HashMap artifactMap = new HashMap();
        for (String entryName : this.leftoverArtifacts.keySet()) {
            String extension = this.getEntryExtension(entryName);
            if (!this.leftoverArtifacts.containsKey(entryName)) continue;
            ArtifactSerializer factory = this.artifactSerializers.get(extension);
            if (factory == null) {
                throw new InvalidFormatException("Unknown artifact format: " + extension);
            }
            artifactMap.put(entryName, factory.create(new ByteArrayInputStream(this.leftoverArtifacts.get(entryName))));
        }
        this.leftoverArtifacts = null;
        this.artifactMap.putAll(artifactMap);
    }

    private String getEntryExtension(String entry) throws InvalidFormatException {
        int extensionIndex = entry.lastIndexOf(46) + 1;
        if (extensionIndex == -1 || extensionIndex >= entry.length()) {
            throw new InvalidFormatException("Entry name must have type extension: " + entry);
        }
        return entry.substring(extensionIndex);
    }

    protected ArtifactSerializer getArtifactSerializer(String resourceName) {
        String extension = null;
        try {
            extension = this.getEntryExtension(resourceName);
        }
        catch (InvalidFormatException e) {
            throw new IllegalStateException(e);
        }
        return this.artifactSerializers.get(extension);
    }

    protected static Map<String, ArtifactSerializer> createArtifactSerializers() {
        HashMap<String, ArtifactSerializer> serializers = new HashMap<String, ArtifactSerializer>();
        GenericModelSerializer.register(serializers);
        PropertiesSerializer.register(serializers);
        DictionarySerializer.register(serializers);
        return serializers;
    }

    protected void createArtifactSerializers(Map<String, ArtifactSerializer> serializers) {
        if (this.toolFactory != null) {
            serializers.putAll(this.toolFactory.createArtifactSerializersMap());
        }
    }

    private void createBaseArtifactSerializers(Map<String, ArtifactSerializer> serializers) {
        serializers.putAll(BaseModel.createArtifactSerializers());
    }

    protected void validateArtifactMap() throws InvalidFormatException {
        if (!(this.artifactMap.get(MANIFEST_ENTRY) instanceof Properties)) {
            throw new InvalidFormatException("Missing the manifest.properties!");
        }
        String versionString = this.getManifestProperty(VERSION_PROPERTY);
        if (versionString != null) {
            Version version;
            try {
                version = Version.parse(versionString);
            }
            catch (NumberFormatException e) {
                throw new InvalidFormatException("Unable to parse model version '" + versionString + "'!", e);
            }
            if (!Version.currentVersion().equals(Version.DEV_VERSION)) {
                if (Version.currentVersion().getMajor() != version.getMajor() || Version.currentVersion().getMinor() != version.getMinor()) {
                    throw new InvalidFormatException("Model version " + version + " is not supported by this (" + Version.currentVersion() + ") version of OpenNLP!");
                }
                if (!Version.currentVersion().isSnapshot() && version.isSnapshot()) {
                    throw new InvalidFormatException("Model version " + version + " is a snapshot - snapshot models are not " + "supported by this non-snapshot version (" + Version.currentVersion() + ") of OpenNLP!");
                }
            }
        } else {
            throw new InvalidFormatException("Missing OpenNLP-Version property in manifest.properties!");
        }
        if (this.getManifestProperty(COMPONENT_NAME_PROPERTY) == null) {
            throw new InvalidFormatException("Missing Component-Name property in manifest.properties!");
        }
        if (!this.getManifestProperty(COMPONENT_NAME_PROPERTY).equals(this.componentName)) {
            throw new InvalidFormatException("The " + this.componentName + " cannot load a model for the " + this.getManifestProperty(COMPONENT_NAME_PROPERTY) + "!");
        }
        if (this.getManifestProperty(LANGUAGE_PROPERTY) == null) {
            throw new InvalidFormatException("Missing Language property in manifest.properties!");
        }
        String factoryName = this.getManifestProperty(FACTORY_NAME);
        if (factoryName != null) {
            try {
                if (ExtensionLoader.instantiateExtension(BaseToolFactory.class, factoryName) == null) {
                    throw new InvalidFormatException("Could not load an user extension specified by the model: " + factoryName);
                }
            }
            catch (Exception e) {
                throw new InvalidFormatException("Could not load an user extension specified by the model: " + factoryName, e);
            }
        }
        if (this.toolFactory != null) {
            this.toolFactory.validateArtifactMap();
        }
    }

    protected void checkArtifactMap() {
        if (!this.finishedLoadingArtifacts) {
            throw new IllegalStateException("The method BaseModel.finishLoadingArtifacts(..) was not called by BaseModel sub-class.");
        }
        try {
            this.validateArtifactMap();
        }
        catch (InvalidFormatException e) {
            throw new IllegalArgumentException(e);
        }
    }

    @Override
    public final String getManifestProperty(String key) {
        Properties manifest = (Properties)this.artifactMap.get(MANIFEST_ENTRY);
        return manifest.getProperty(key);
    }

    protected final void setManifestProperty(String key, String value) {
        Properties manifest = (Properties)this.artifactMap.get(MANIFEST_ENTRY);
        manifest.setProperty(key, value);
    }

    @Override
    public final String getLanguage() {
        return this.getManifestProperty(LANGUAGE_PROPERTY);
    }

    public final Version getVersion() {
        String version = this.getManifestProperty(VERSION_PROPERTY);
        return Version.parse(version);
    }

    public final void serialize(OutputStream out) throws IOException {
        if (!this.subclassSerializersInitiated) {
            throw new IllegalStateException("The method BaseModel.loadArtifactSerializers() was not called by BaseModel subclass constructor.");
        }
        ZipOutputStream zip = new ZipOutputStream(out);
        for (String name : this.artifactMap.keySet()) {
            zip.putNextEntry(new ZipEntry(name));
            ArtifactSerializer serializer = this.getArtifactSerializer(name);
            if (serializer == null) {
                throw new IllegalStateException("Missing serializer for " + name);
            }
            serializer.serialize(this.artifactMap.get(name), zip);
            zip.closeEntry();
        }
        zip.finish();
        zip.flush();
    }

    @Override
    public <T> T getArtifact(String key) {
        Object artifact = this.artifactMap.get(key);
        if (artifact == null) {
            return null;
        }
        return (T)artifact;
    }

    private static byte[] toByteArray(InputStream input) throws IOException {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        byte[] buffer = new byte[4096];
        int count = 0;
        int n = 0;
        while (-1 != (n = input.read(buffer))) {
            output.write(buffer, 0, n);
            count += n;
        }
        return output.toByteArray();
    }

    @Override
    public boolean isLoadedFromSerialized() {
        return this.isLoadedFromSerialized;
    }
}

