## ---- include = FALSE---------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)

## ----setup--------------------------------------------------------------------
library(calculus)

## -----------------------------------------------------------------------------
i <- integral(f = "x", bounds = list(x = c(0,1)))
i$value

## -----------------------------------------------------------------------------
i <- integral(f = function(x) x, bounds = list(x = c(0,1)))
i$value

## -----------------------------------------------------------------------------
i <- integral(f = "y*x", bounds = list(x = c(0,1), y = 2))
i$value

## -----------------------------------------------------------------------------
i <- integral(f = "y*x", bounds = list(x = c(0,1), y = c(0,1)))
i$value

## -----------------------------------------------------------------------------
i <- integral(f = 1, 
              bounds = list(r = c(0,1), theta = c(0,2*pi)), 
              coordinates = "polar")
i$value

## -----------------------------------------------------------------------------
i <- integral(f = 1, 
              bounds = list(r = c(0,1), theta = c(0,pi), phi = c(0,2*pi)), 
              coordinates = "spherical")
i$value

## -----------------------------------------------------------------------------
V <- "1/(4*pi*r)"

## -----------------------------------------------------------------------------
E <- -1 %prod% gradient(V, c("r","theta","phi"), coordinates = "spherical")

## -----------------------------------------------------------------------------
i <- integral(E[1], 
              bounds = list(r = 1, theta = c(0,pi), phi = c(0,2*pi)), 
              coordinates = "spherical")
i$value

