/*
 * Decompiled with CFR 0.152.
 */
package weka.core;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.BitSet;
import weka.core.Instances;
import weka.core.RevisionHandler;
import weka.core.RevisionUtils;

public class AttributeLocator
implements Serializable,
Comparable<AttributeLocator>,
RevisionHandler {
    private static final long serialVersionUID = -2932848827681070345L;
    protected int[] m_AllowedIndices = null;
    protected BitSet m_Attributes = null;
    protected ArrayList<AttributeLocator> m_Locators = null;
    protected int m_Type = -1;
    protected Instances m_Data = null;
    protected int[] m_Indices = null;
    protected int[] m_LocatorIndices = null;

    public AttributeLocator(Instances data, int type) {
        this(data, type, 0, data.numAttributes() - 1);
    }

    public AttributeLocator(Instances data, int type, int fromIndex, int toIndex) {
        int[] indices = new int[toIndex - fromIndex + 1];
        for (int i = 0; i < indices.length; ++i) {
            indices[i] = fromIndex + i;
        }
        this.initialize(data, type, indices);
    }

    public AttributeLocator(Instances data, int type, int[] indices) {
        this.initialize(data, type, indices);
    }

    protected void initialize(Instances data, int type, int[] indices) {
        this.m_Data = new Instances(data, 0);
        this.m_Type = type;
        this.m_AllowedIndices = new int[indices.length];
        System.arraycopy(indices, 0, this.m_AllowedIndices, 0, indices.length);
        this.locate();
        this.m_Indices = this.find(true);
        this.m_LocatorIndices = this.find(false);
    }

    public int getType() {
        return this.m_Type;
    }

    public int[] getAllowedIndices() {
        return this.m_AllowedIndices;
    }

    protected void locate() {
        this.m_Attributes = new BitSet(this.m_AllowedIndices.length);
        this.m_Locators = new ArrayList();
        for (int i = 0; i < this.m_AllowedIndices.length; ++i) {
            if (this.m_Data.attribute(this.m_AllowedIndices[i]).type() == 4) {
                this.m_Locators.add(new AttributeLocator(this.m_Data.attribute(this.m_AllowedIndices[i]).relation(), this.getType()));
            } else {
                this.m_Locators.add(null);
            }
            this.m_Attributes.set(i, this.m_Data.attribute(this.m_AllowedIndices[i]).type() == this.getType());
        }
    }

    public Instances getData() {
        return this.m_Data;
    }

    protected int[] find(boolean findAtts) {
        int i;
        ArrayList<Integer> indices = new ArrayList<Integer>();
        if (findAtts) {
            for (i = 0; i < this.m_Attributes.size(); ++i) {
                if (!this.m_Attributes.get(i)) continue;
                indices.add(new Integer(i));
            }
        } else {
            for (i = 0; i < this.m_Locators.size(); ++i) {
                if (this.m_Locators.get(i) == null) continue;
                indices.add(new Integer(i));
            }
        }
        int[] result = new int[indices.size()];
        for (i = 0; i < indices.size(); ++i) {
            result[i] = (Integer)indices.get(i);
        }
        return result;
    }

    public int getActualIndex(int index) {
        return this.m_AllowedIndices[index];
    }

    public int[] getAttributeIndices() {
        return this.m_Indices;
    }

    public int[] getLocatorIndices() {
        return this.m_LocatorIndices;
    }

    public AttributeLocator getLocator(int index) {
        return this.m_Locators.get(index);
    }

    @Override
    public int compareTo(AttributeLocator o) {
        int result = 0;
        if (this.getType() < o.getType()) {
            result = -1;
        } else if (this.getType() > o.getType()) {
            result = 1;
        } else if (this.getAllowedIndices().length < o.getAllowedIndices().length) {
            result = -1;
        } else if (this.getAllowedIndices().length > o.getAllowedIndices().length) {
            result = 1;
        } else {
            for (int i = 0; i < this.getAllowedIndices().length; ++i) {
                if (this.getAllowedIndices()[i] < o.getAllowedIndices()[i]) {
                    result = -1;
                    break;
                }
                if (this.getAllowedIndices()[i] > o.getAllowedIndices()[i]) {
                    result = 1;
                    break;
                }
                result = 0;
            }
        }
        return result;
    }

    public boolean equals(Object o) {
        return this.compareTo((AttributeLocator)o) == 0;
    }

    public String toString() {
        return this.m_Attributes.toString();
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 10649 $");
    }
}

