/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jclec.algorithm.niching;

import java.util.ArrayList;
import java.util.List;
import net.sf.jclec.IIndividual;
import net.sf.jclec.algorithm.classic.SG;
import net.sf.jclec.selector.BettersSelector;
import net.sf.jclec.selector.WorsesSelector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class NichingAlgorithm<I extends IIndividual>
extends SG<I> {
    protected List<I> nset = new ArrayList<I>();
    protected BettersSelector<I> bettersSelector = new BettersSelector(this);
    protected WorsesSelector<I> worsesSelector = new WorsesSelector(this);

    @Override
    protected void doSelection() {
        this.nset.clear();
        this.createNiches();
        this.pset = this.parentsSelector.select(this.nset, this.bset.size());
    }

    @Override
    protected void doGeneration() {
        for (IIndividual ind : this.pset) {
            ind.setFitness(null);
        }
        super.doGeneration();
    }

    @Override
    protected void doUpdate() {
        if (this.cset.size() < this.bset.size()) {
            this.cset.addAll(this.bettersSelector.select(this.bset, this.bset.size() - this.cset.size()));
        } else {
            IIndividual bestInC;
            IIndividual bestInB = (IIndividual)this.bettersSelector.select(this.bset, 1).get(0);
            if (this.compareIndividuals(bestInB, bestInC = (IIndividual)this.bettersSelector.select(this.cset, 1).get(0)) == 1) {
                IIndividual worstInC = (IIndividual)this.worsesSelector.select(this.cset, 1).get(0);
                this.cset.remove(worstInC);
                this.cset.add(bestInB);
            }
        }
        this.bset = this.cset;
        this.cset = null;
        this.rset = null;
        this.pset = null;
    }

    protected abstract void createNiches();

    protected final int compareIndividuals(I one, I two) {
        return this.evaluator.getComparator().compare(one.getFitness(), two.getFitness());
    }
}

