/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.Neural_Networks.RBFN_incremental_CL;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import keel.Dataset.Attribute;
import keel.Dataset.Attributes;
import keel.Dataset.Instance;
import keel.Dataset.InstanceSet;

public class ProcDataset {
    private double[][] X = null;
    private boolean[][] missing = null;
    private double[] Y = null;
    private int[] C = null;
    private double[] imax;
    private double[] imin;
    private double omax;
    private double omin;
    private int ndata;
    private int nvariables;
    private int ninputs;
    private int nclasses;
    static final boolean debug = false;
    private InstanceSet IS;

    public double[][] getX() {
        return this.X;
    }

    public double[] getY() {
        return this.Y;
    }

    public int[] getC() {
        return this.C;
    }

    public double[] getimax() {
        return this.imax;
    }

    public double[] getimin() {
        return this.imin;
    }

    public double getomax() {
        return this.omax;
    }

    public double getomin() {
        return this.omin;
    }

    public int getndata() {
        return this.ndata;
    }

    public int getnvariables() {
        return this.nvariables;
    }

    public int getninputs() {
        return this.ninputs;
    }

    public int getnclasses() {
        return this.nclasses;
    }

    public boolean isMissing(int i, int j) {
        return this.missing[i][j];
    }

    public ProcDataset(String nfexamples, boolean train) throws IOException {
        try {
            this.IS = new InstanceSet();
            this.IS.readSet(nfexamples, train);
            System.out.println("Dataset analyzed: " + Attributes.getRelationName());
        }
        catch (Exception e) {
            System.out.println("Exception in readSet");
            e.printStackTrace();
        }
    }

    public int datasetType() {
        if (Attributes.getOutputNumAttributes() >= 1) {
            if (Attributes.hasNominalAttributes()) {
                return 1;
            }
            return 0;
        }
        return 2;
    }

    public void processClassifierDataset() throws IOException {
        try {
            this.ndata = this.IS.getNumInstances();
            this.ninputs = Attributes.getInputNumAttributes();
            this.nvariables = this.ninputs + Attributes.getOutputNumAttributes();
            if (Attributes.getOutputNumAttributes() > 1) {
                System.out.println("This algorithm can not process MIMO datasets");
                System.out.println("All outputs but the first one will be removed");
            }
            boolean noOutputs = false;
            if (Attributes.getOutputNumAttributes() < 1) {
                System.out.println("This algorithm cannot process datasets without outputs");
                System.out.println("Zero-valued output generated");
                noOutputs = true;
            }
            this.X = new double[this.ndata][this.ninputs];
            this.missing = new boolean[this.ndata][this.ninputs];
            this.C = new int[this.ndata];
            this.imax = new double[this.ninputs];
            this.imin = new double[this.ninputs];
            this.omax = 0.0;
            this.omin = 0.0;
            this.nclasses = 0;
            for (int i = 0; i < this.X.length; ++i) {
                Instance inst = this.IS.getInstance(i);
                for (int j = 0; j < this.ninputs; ++j) {
                    this.X[i][j] = this.IS.getInputNumericValue(i, j);
                    this.missing[i][j] = inst.getInputMissingValues(j);
                    if (this.X[i][j] > this.imax[j] || i == 0) {
                        this.imax[j] = this.X[i][j];
                    }
                    if (!(this.X[i][j] < this.imin[j]) && i != 0) continue;
                    this.imin[j] = this.X[i][j];
                }
                this.C[i] = noOutputs ? 0 : (int)this.IS.getOutputNumericValue(i, 0);
                if (this.C[i] <= this.nclasses) continue;
                this.nclasses = this.C[i];
            }
            ++this.nclasses;
            System.out.println("Number of classes=" + this.nclasses);
        }
        catch (Exception e) {
            System.out.println("DBG: Exception in readSet");
            e.printStackTrace();
        }
    }

    public void processModelDataset() throws IOException {
        try {
            this.ndata = this.IS.getNumInstances();
            this.ninputs = Attributes.getInputNumAttributes();
            this.nvariables = this.ninputs + Attributes.getOutputNumAttributes();
            if (Attributes.getOutputNumAttributes() > 1) {
                System.out.println("This algorithm can not process MIMO datasets");
                System.out.println("All outputs but the first one will be removed");
            }
            boolean noOutputs = false;
            if (Attributes.getOutputNumAttributes() < 1) {
                System.out.println("This algorithm can not process datasets without outputs");
                System.out.println("Zero-valued output generated");
                noOutputs = true;
            }
            this.X = new double[this.ndata][this.ninputs];
            this.missing = new boolean[this.ndata][this.ninputs];
            this.Y = new double[this.ndata];
            this.imax = new double[this.ninputs];
            this.imin = new double[this.ninputs];
            this.omax = 0.0;
            this.omin = 0.0;
            this.nclasses = 0;
            for (int i = 0; i < this.X.length; ++i) {
                Instance inst = this.IS.getInstance(i);
                for (int j = 0; j < this.ninputs; ++j) {
                    this.X[i][j] = this.IS.getInputNumericValue(i, j);
                    this.missing[i][j] = inst.getInputMissingValues(j);
                    if (this.X[i][j] > this.imax[j] || i == 0) {
                        this.imax[j] = this.X[i][j];
                    }
                    if (!(this.X[i][j] < this.imin[j]) && i != 0) continue;
                    this.imin[j] = this.X[i][j];
                }
                this.Y[i] = noOutputs ? 0.0 : this.IS.getOutputNumericValue(i, 0);
                if (this.Y[i] > this.omax || i == 0) {
                    this.omax = this.Y[i];
                }
                if (!(this.Y[i] < this.omin) && i != 0) continue;
                this.omin = this.Y[i];
            }
        }
        catch (Exception e) {
            System.out.println("DBG: Exception in readSet");
            e.printStackTrace();
        }
    }

    public void processClusterDataset(String nfexamples, boolean train) throws IOException {
        try {
            this.ndata = this.IS.getNumInstances();
            this.ninputs = Attributes.getInputNumAttributes();
            this.nvariables = this.ninputs + Attributes.getOutputNumAttributes();
            if (Attributes.getOutputNumAttributes() != 0) {
                System.out.println("This algorithm can not process datasets with  outputs");
                System.out.println("All outputs will be removed");
            }
            this.X = new double[this.ndata][this.ninputs];
            this.missing = new boolean[this.ndata][this.ninputs];
            this.imax = new double[this.ninputs];
            this.imin = new double[this.ninputs];
            this.omax = 0.0;
            this.omin = 0.0;
            this.nclasses = 0;
            for (int i = 0; i < this.X.length; ++i) {
                Instance inst = this.IS.getInstance(i);
                for (int j = 0; j < this.ninputs; ++j) {
                    this.X[i][j] = this.IS.getInputNumericValue(i, j);
                    this.missing[i][j] = inst.getInputMissingValues(j);
                    if (this.X[i][j] > this.imax[j] || i == 0) {
                        this.imax[j] = this.X[i][j];
                    }
                    if (!(this.X[i][j] < this.imin[j]) && i != 0) continue;
                    this.imin[j] = this.X[i][j];
                }
            }
        }
        catch (Exception e) {
            System.out.println("DBG: Exception in readSet");
            e.printStackTrace();
        }
    }

    private void CopyHeaderTest(PrintStream p) {
        p.println("@relation " + Attributes.getRelationName());
        p.print(Attributes.getInputAttributesHeader());
        p.print(Attributes.getOutputAttributesHeader());
        p.println(Attributes.getInputHeader());
        p.println(Attributes.getOutputHeader());
        p.println("@data");
    }

    public void generateResultsModeling(String Foutput, int[] real, int[] obtained) {
        try {
            FileOutputStream out = new FileOutputStream(Foutput);
            PrintStream p = new PrintStream(out);
            this.CopyHeaderTest(p);
            for (int i = 0; i < real.length; ++i) {
                p.print(real[i] + " " + obtained[i] + "\n");
            }
            p.close();
        }
        catch (Exception e) {
            System.err.println("Error building file for results: " + Foutput);
        }
    }

    public void generateResultsModeling(String Foutput, double[] real, double[] obtained) {
        try {
            FileOutputStream out = new FileOutputStream(Foutput);
            PrintStream p = new PrintStream(out);
            this.CopyHeaderTest(p);
            for (int i = 0; i < real.length; ++i) {
                p.print(real[i] + " " + obtained[i] + "\n");
            }
            p.close();
        }
        catch (Exception e) {
            System.err.println("Error building file for results: " + Foutput);
        }
    }

    public void generateResultsClasification(String Foutput, int[] real, int[] obtained) {
        Attribute at = Attributes.getOutputAttribute(0);
        boolean isNominal = at.getType() == 0;
        try {
            FileOutputStream out = new FileOutputStream(Foutput);
            PrintStream p = new PrintStream(out);
            this.CopyHeaderTest(p);
            for (int i = 0; i < real.length; ++i) {
                if (isNominal) {
                    p.print(at.getNominalValue(real[i]) + " " + at.getNominalValue(obtained[i]) + "\n");
                    continue;
                }
                p.print(real[i] + " " + obtained[i] + "\n");
            }
            p.close();
        }
        catch (Exception e) {
            System.err.println("Error building file for results: " + Foutput);
        }
    }
}

