/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.randvar;

import umontreal.iro.lecuyer.probdist.NormalDist;
import umontreal.iro.lecuyer.randvar.NormalGen;
import umontreal.iro.lecuyer.rng.RandomStream;

public class NormalBoxMullerGen
extends NormalGen {
    private double mu;
    private double sigma;
    private boolean available = false;
    private double[] variates = new double[2];
    private static double[] staticVariates = new double[2];

    public NormalBoxMullerGen(RandomStream randomStream, NormalDist normalDist) {
        super(randomStream, normalDist);
        this.mu = normalDist.getMu();
        this.sigma = normalDist.getSigma();
    }

    public double nextDouble() {
        if (this.available) {
            this.available = false;
            return this.mu + this.sigma * this.variates[1];
        }
        NormalBoxMullerGen.boxMuller(this.stream, this.mu, this.sigma, this.variates);
        this.available = true;
        return this.mu + this.sigma * this.variates[0];
    }

    public static double nextDouble(RandomStream randomStream, double d, double d2) {
        NormalBoxMullerGen.boxMuller(randomStream, d, d2, staticVariates);
        return d + d2 * staticVariates[0];
    }

    private static void boxMuller(RandomStream randomStream, double d, double d2, double[] dArray) {
        double d3 = randomStream.nextDouble();
        double d4 = randomStream.nextDouble();
        double d5 = Math.sqrt(-2.0 * Math.log(d3));
        dArray[1] = d5 * Math.sin(Math.PI * 2 * d4);
        dArray[0] = d5 * Math.cos(Math.PI * 2 * d4);
    }
}

