/*
 * Decompiled with CFR 0.152.
 */
package org.rosuda.REngine;

import java.util.Vector;

public class RFactor {
    int[] ids;
    String[] levels;
    int index_base;

    public RFactor() {
        this.ids = new int[0];
        this.levels = new String[0];
    }

    public RFactor(int[] i, String[] v, boolean copy2, int index_base) {
        if (i == null) {
            i = new int[]{};
        }
        if (v == null) {
            v = new String[]{};
        }
        if (copy2) {
            this.ids = new int[i.length];
            System.arraycopy(i, 0, this.ids, 0, i.length);
            this.levels = new String[v.length];
            System.arraycopy(v, 0, this.levels, 0, v.length);
        } else {
            this.ids = i;
            this.levels = v;
        }
        this.index_base = index_base;
    }

    public RFactor(String[] c, int index_base) {
        int i;
        this.index_base = index_base;
        if (c == null) {
            c = new String[]{};
        }
        Vector<String> lv = new Vector<String>();
        this.ids = new int[c.length];
        for (i = 0; i < c.length; ++i) {
            int ix;
            int n = ix = c[i] == null ? -1 : lv.indexOf(c[i]);
            if (ix < 0 && c[i] != null) {
                ix = lv.size();
                lv.add(c[i]);
            }
            this.ids[i] = ix < 0 ? Integer.MIN_VALUE : ix + index_base;
        }
        this.levels = new String[lv.size()];
        for (i = 0; i < this.levels.length; ++i) {
            this.levels[i] = (String)lv.elementAt(i);
        }
    }

    public RFactor(String[] c) {
        this(c, 1);
    }

    public RFactor(int[] i, String[] v) {
        this(i, v, true, 1);
    }

    public String at(int i) {
        int li = this.ids[i] - this.index_base;
        return li < 0 || li > this.levels.length ? null : this.levels[li];
    }

    public boolean contains(int li) {
        for (int i = 0; i < this.ids.length; ++i) {
            if (this.ids[i] != li) continue;
            return true;
        }
        return false;
    }

    public boolean contains(String name) {
        int li = this.levelIndex(name);
        if (li < 0) {
            return false;
        }
        for (int i = 0; i < this.ids.length; ++i) {
            if (this.ids[i] != li) continue;
            return true;
        }
        return false;
    }

    public int count(int levelIndex) {
        int ct = 0;
        for (int i = 0; i < this.ids.length; ++i) {
            if (this.ids[i] != levelIndex) continue;
            ++ct;
        }
        return ct;
    }

    public int count(String name) {
        return this.count(this.levelIndex(name));
    }

    public int[] counts() {
        int[] c = new int[this.levels.length];
        for (int i = 0; i < this.ids.length; ++i) {
            int li = this.ids[i] - this.index_base;
            if (li < 0 || li >= this.levels.length) continue;
            int n = li;
            c[n] = c[n] + 1;
        }
        return c;
    }

    public int levelIndex(String name) {
        if (name == null) {
            return -1;
        }
        for (int i = 0; i < this.levels.length; ++i) {
            if (this.levels[i] == null || !this.levels[i].equals(name)) continue;
            return i + this.index_base;
        }
        return -1;
    }

    public String[] levels() {
        return this.levels;
    }

    public int[] asIntegers() {
        return this.ids;
    }

    public int[] asIntegers(int desired_index_base) {
        if (desired_index_base == this.index_base) {
            return this.ids;
        }
        int[] ix = new int[this.ids.length];
        for (int j = 0; j < this.ids.length; ++j) {
            ix[j] = this.ids[j] - this.index_base + desired_index_base;
        }
        return ix;
    }

    public String levelAtIndex(int li) {
        return (li -= this.index_base) < 0 || li > this.levels.length ? null : this.levels[li];
    }

    public int indexAt(int i) {
        return this.ids[i];
    }

    public String[] asStrings() {
        String[] s = new String[this.ids.length];
        for (int i = 0; i < this.ids.length; ++i) {
            s[i] = this.at(i);
        }
        return s;
    }

    public int indexBase() {
        return this.index_base;
    }

    public int size() {
        return this.ids.length;
    }

    public String toString() {
        return super.toString() + "[" + this.ids.length + "," + this.levels.length + ",#" + this.index_base + "]";
    }
}

