/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tdouble.impl;

import cern.colt.Timer;
import cern.colt.matrix.tdouble.DoubleMatrix2D;
import cern.colt.matrix.tdouble.impl.DenseDoubleMatrix2D;
import cern.colt.matrix.tdouble.impl.SparseDoubleMatrix2D;
import cern.jet.math.tdouble.DoubleFunctions;

class BenchmarkMatrix2D {
    protected BenchmarkMatrix2D() {
        throw new RuntimeException("Non instantiable");
    }

    public static void doubleBenchmark(int n, int n2, int n3, String string, boolean bl, int n4, double d, double d2) {
        int n5;
        int n6;
        int n7;
        int n8;
        System.out.println("benchmarking double matrix");
        Timer timer = new Timer();
        Timer timer2 = new Timer();
        Timer timer3 = new Timer();
        Timer timer4 = new Timer();
        Timer timer5 = new Timer();
        Timer timer6 = new Timer();
        timer5.start();
        int n9 = 0;
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n3; ++j) {
                for (n8 = 0; n8 < n2; ++n8) {
                    ++n9;
                }
            }
        }
        timer5.stop();
        System.out.println(n9);
        timer6.start();
        n9 = 3;
        double d3 = 0.0;
        for (n8 = 0; n8 < n; ++n8) {
            boolean bl2 = false;
            for (int i = 0; i < n3; ++i) {
                for (int j = 0; j < n2; ++j) {
                    d3 += (double)n9;
                }
            }
        }
        timer6.stop();
        System.out.println(d3);
        long l = Runtime.getRuntime().freeMemory();
        long l2 = (long)n2 * (long)n3 * (long)n;
        DoubleMatrix2D doubleMatrix2D = null;
        if (string.equals("sparse")) {
            doubleMatrix2D = new SparseDoubleMatrix2D(n2, n3, n4, d, d2);
        } else if (string.equals("dense")) {
            doubleMatrix2D = new DenseDoubleMatrix2D(n2, n3);
        } else {
            throw new RuntimeException("unknown kind");
        }
        System.out.println("\nNow filling...");
        for (int i = 0; i < n; ++i) {
            doubleMatrix2D.assign(0.0);
            doubleMatrix2D.ensureCapacity(n4);
            if (string.equals("sparse")) {
                ((SparseDoubleMatrix2D)doubleMatrix2D).ensureCapacity(n4);
            }
            timer.start();
            int n10 = 0;
            for (int j = 0; j < n2; ++j) {
                for (int k = 0; k < n3; ++k) {
                    doubleMatrix2D.setQuick(j, k, n10++);
                }
            }
            timer.stop();
        }
        timer.display();
        timer.minus(timer5).display();
        System.out.println((double)l2 / timer.minus(timer5).seconds() + " elements / sec");
        Runtime.getRuntime().gc();
        try {
            Thread.currentThread();
            Thread.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        long l3 = Runtime.getRuntime().freeMemory();
        System.out.println("KB needed=" + (l - l3) / 1024L);
        System.out.println("bytes needed per non-zero=" + (double)(l - l3) / (double)doubleMatrix2D.cardinality());
        if (bl) {
            System.out.println(doubleMatrix2D);
            if (string.equals("sparse")) {
                System.out.println("map=" + ((SparseDoubleMatrix2D)doubleMatrix2D).elements());
            }
        }
        System.out.println("\nNow reading...");
        timer2.start();
        double d4 = 0.0;
        for (int i = 0; i < n; ++i) {
            for (n7 = 0; n7 < n2; ++n7) {
                for (n6 = 0; n6 < n3; ++n6) {
                    d4 += doubleMatrix2D.getQuick(n7, n6);
                }
            }
        }
        timer2.stop().display();
        timer2.minus(timer6).display();
        System.out.println((double)l2 / timer2.minus(timer6).seconds() + " elements / sec");
        if (bl) {
            System.out.println(doubleMatrix2D);
        }
        System.out.println(d4);
        System.out.println("\nNow reading view...");
        DoubleMatrix2D doubleMatrix2D2 = doubleMatrix2D.viewPart(0, 0, n2, n3);
        timer4.start();
        d4 = 0.0;
        for (n7 = 0; n7 < n; ++n7) {
            for (n6 = 0; n6 < n2; ++n6) {
                for (n5 = 0; n5 < n3; ++n5) {
                    d4 += doubleMatrix2D2.getQuick(n6, n5);
                }
            }
        }
        timer4.stop().display();
        timer4.minus(timer6).display();
        System.out.println((double)l2 / timer4.minus(timer6).seconds() + " elements / sec");
        if (bl) {
            System.out.println(doubleMatrix2D2);
        }
        System.out.println(d4);
        System.out.println("\nNow removing...");
        l = Runtime.getRuntime().freeMemory();
        for (n7 = 0; n7 < n; ++n7) {
            for (n6 = 0; n6 < n2; ++n6) {
                for (n5 = 0; n5 < n3; ++n5) {
                    doubleMatrix2D.setQuick(n6, n5, 1.0);
                }
            }
            timer3.start();
            for (n6 = 0; n6 < n2; ++n6) {
                for (n5 = 0; n5 < n3; ++n5) {
                    doubleMatrix2D.setQuick(n6, n5, 0.0);
                }
            }
            timer3.stop();
        }
        timer3.display();
        timer3.minus(timer5).display();
        System.out.println((double)l2 / timer3.minus(timer5).seconds() + " elements / sec");
        Runtime.getRuntime().gc();
        try {
            Thread.currentThread();
            Thread.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        l3 = Runtime.getRuntime().freeMemory();
        System.out.println("KB needed=" + (l - l3) / 1024L);
        System.out.println("KB free=" + l3 / 1024L);
        if (bl) {
            System.out.println(doubleMatrix2D);
        }
        System.out.println("bye bye.");
    }

    public static void doubleBenchmarkMult(int n, int n2, int n3, String string, boolean bl, int n4, double d, double d2) {
        int n5;
        System.out.println("benchmarking double matrix");
        Timer timer = new Timer();
        Timer timer2 = new Timer();
        long l = (long)n2 * (long)n3 * (long)n;
        DoubleMatrix2D doubleMatrix2D = null;
        if (string.equals("sparse")) {
            doubleMatrix2D = new SparseDoubleMatrix2D(n2, n3, n4, d, d2);
        } else if (string.equals("dense")) {
            doubleMatrix2D = new DenseDoubleMatrix2D(n2, n3);
        } else {
            throw new RuntimeException("unknown kind");
        }
        System.out.println("\nNow multiplying...");
        doubleMatrix2D.assign(1.0);
        for (n5 = 0; n5 < n; ++n5) {
            timer.start();
            doubleMatrix2D.assign(DoubleFunctions.mult(3.0));
            timer.stop();
        }
        timer.display();
        System.out.println((double)l / timer.seconds() + " elements / sec");
        if (bl) {
            System.out.println(doubleMatrix2D);
        }
        System.out.println("\nNow multiplying2...");
        doubleMatrix2D.assign(1.0);
        for (n5 = 0; n5 < n; ++n5) {
            timer2.start();
            doubleMatrix2D.assign(DoubleFunctions.mult(3.0));
            timer2.stop();
        }
        timer2.display();
        System.out.println((double)l / timer2.seconds() + " elements / sec");
        if (bl) {
            System.out.println(doubleMatrix2D);
        }
        System.out.println("bye bye.");
    }

    public static void doubleBenchmarkPrimitive(int n, int n2, int n3, boolean bl) {
        int n4;
        int n5;
        int n6;
        int n7;
        Timer timer = new Timer();
        Timer timer2 = new Timer();
        Timer timer3 = new Timer();
        Timer timer4 = new Timer();
        Timer timer5 = new Timer();
        timer4.start();
        int n8 = 0;
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n3; ++j) {
                for (n7 = 0; n7 < n2; ++n7) {
                    ++n8;
                }
            }
        }
        timer4.stop();
        System.out.println(n8);
        timer5.start();
        n8 = 3;
        double d = 0.0;
        for (n7 = 0; n7 < n; ++n7) {
            for (int i = 0; i < n3; ++i) {
                for (int j = 0; j < n2; ++j) {
                    d += (double)n8;
                }
            }
        }
        timer5.stop();
        System.out.println(d);
        long l = Runtime.getRuntime().freeMemory();
        long l2 = (long)n2 * (long)n3 * (long)n;
        double[][] dArray = new double[n2][n3];
        System.out.println("\nNow filling...");
        for (int i = 0; i < n; ++i) {
            timer.start();
            int n9 = 0;
            for (int j = 0; j < n3; ++j) {
                for (int k = 0; k < n2; ++k) {
                    dArray[k][j] = n9++;
                }
            }
            timer.stop();
        }
        timer.display();
        timer.minus(timer4).display();
        System.out.println((double)l2 / timer.minus(timer4).seconds() + " elements / sec");
        Runtime.getRuntime().gc();
        try {
            Thread.currentThread();
            Thread.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        long l3 = Runtime.getRuntime().freeMemory();
        System.out.println("KB needed=" + (l - l3) / 1024L);
        if (bl) {
            DenseDoubleMatrix2D denseDoubleMatrix2D = new DenseDoubleMatrix2D(n2, n3);
            denseDoubleMatrix2D.assign(dArray);
            System.out.println(denseDoubleMatrix2D);
        }
        System.out.println("\nNow reading...");
        timer2.start();
        double d2 = 0.0;
        for (n6 = 0; n6 < n; ++n6) {
            for (n5 = 0; n5 < n3; ++n5) {
                for (n4 = 0; n4 < n2; ++n4) {
                    d2 += dArray[n4][n5];
                }
            }
        }
        timer2.stop().display();
        timer2.minus(timer5).display();
        System.out.println((double)l2 / timer2.minus(timer5).seconds() + " elements / sec");
        if (bl) {
            DenseDoubleMatrix2D denseDoubleMatrix2D = new DenseDoubleMatrix2D(n2, n3);
            denseDoubleMatrix2D.assign(dArray);
            System.out.println(denseDoubleMatrix2D);
        }
        System.out.println(d2);
        System.out.println("\nNow removing...");
        l = Runtime.getRuntime().freeMemory();
        for (n6 = 0; n6 < n; ++n6) {
            timer3.start();
            for (n5 = 0; n5 < n3; ++n5) {
                for (n4 = 0; n4 < n2; ++n4) {
                    dArray[n4][n5] = 0.0;
                }
            }
            timer3.stop();
        }
        timer3.display();
        timer3.minus(timer4).display();
        System.out.println((double)l2 / timer3.minus(timer4).seconds() + " elements / sec");
        Runtime.getRuntime().gc();
        try {
            Thread.currentThread();
            Thread.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        l3 = Runtime.getRuntime().freeMemory();
        System.out.println("KB needed=" + (l - l3) / 1024L);
        System.out.println("KB free=" + l3 / 1024L);
        if (bl) {
            DenseDoubleMatrix2D denseDoubleMatrix2D = new DenseDoubleMatrix2D(n2, n3);
            denseDoubleMatrix2D.assign(dArray);
            System.out.println(denseDoubleMatrix2D);
        }
        System.out.println("bye bye.");
    }

    public static void doubleBenchmarkPrimitiveOptimized(int n, int n2, int n3, boolean bl) {
        int n4;
        double[] dArray;
        int n5;
        int n6;
        int n7;
        Timer timer = new Timer();
        Timer timer2 = new Timer();
        Timer timer3 = new Timer();
        Timer timer4 = new Timer();
        Timer timer5 = new Timer();
        timer4.start();
        int n8 = 0;
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n3; ++j) {
                for (n7 = 0; n7 < n2; ++n7) {
                    ++n8;
                }
            }
        }
        timer4.stop();
        System.out.println(n8);
        timer5.start();
        n8 = 3;
        double d = 0.0;
        for (n7 = 0; n7 < n; ++n7) {
            for (int i = 0; i < n3; ++i) {
                for (int j = 0; j < n2; ++j) {
                    d += (double)n8;
                }
            }
        }
        timer5.stop();
        System.out.println(d);
        long l = Runtime.getRuntime().freeMemory();
        long l2 = (long)n2 * (long)n3 * (long)n;
        double[][] dArray2 = new double[n2][n3];
        System.out.println("\nNow filling...");
        for (int i = 0; i < n; ++i) {
            timer.start();
            int n9 = 0;
            for (int j = 0; j < n2; ++j) {
                double[] dArray3 = dArray2[j];
                for (n6 = 0; n6 < n3; ++n6) {
                    dArray3[n6] = n9++;
                }
            }
            timer.stop();
        }
        timer.display();
        timer.minus(timer4).display();
        System.out.println((double)l2 / timer.minus(timer4).seconds() + " elements / sec");
        Runtime.getRuntime().gc();
        try {
            Thread.currentThread();
            Thread.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        long l3 = Runtime.getRuntime().freeMemory();
        System.out.println("KB needed=" + (l - l3) / 1024L);
        if (bl) {
            DenseDoubleMatrix2D denseDoubleMatrix2D = new DenseDoubleMatrix2D(n2, n3);
            denseDoubleMatrix2D.assign(dArray2);
            System.out.println(denseDoubleMatrix2D);
        }
        System.out.println("\nNow reading...");
        timer2.start();
        double d2 = 0.0;
        for (n6 = 0; n6 < n; ++n6) {
            for (n5 = 0; n5 < n2; ++n5) {
                dArray = dArray2[n5];
                for (n4 = 0; n4 < n3; ++n4) {
                    d2 += dArray[n4];
                }
            }
        }
        timer2.stop().display();
        timer2.minus(timer5).display();
        System.out.println((double)l2 / timer2.minus(timer5).seconds() + " elements / sec");
        if (bl) {
            DenseDoubleMatrix2D denseDoubleMatrix2D = new DenseDoubleMatrix2D(n2, n3);
            denseDoubleMatrix2D.assign(dArray2);
            System.out.println(denseDoubleMatrix2D);
        }
        System.out.println(d2);
        System.out.println("\nNow removing...");
        l = Runtime.getRuntime().freeMemory();
        for (int i = 0; i < n; ++i) {
            timer3.start();
            for (n5 = 0; n5 < n2; ++n5) {
                dArray = dArray2[n5];
                for (n4 = 0; n4 < n3; ++n4) {
                    dArray[n4] = 0.0;
                }
            }
            timer3.stop();
        }
        timer3.display();
        timer3.minus(timer4).display();
        System.out.println((double)l2 / timer3.minus(timer4).seconds() + " elements / sec");
        Runtime.getRuntime().gc();
        try {
            Thread.currentThread();
            Thread.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        l3 = Runtime.getRuntime().freeMemory();
        System.out.println("KB needed=" + (l - l3) / 1024L);
        System.out.println("KB free=" + l3 / 1024L);
        if (bl) {
            DenseDoubleMatrix2D denseDoubleMatrix2D = new DenseDoubleMatrix2D(n2, n3);
            denseDoubleMatrix2D.assign(dArray2);
            System.out.println(denseDoubleMatrix2D);
        }
        System.out.println("bye bye.");
    }

    public static void intBenchmark(int n, int n2, int n3, String string, boolean bl, int n4, double d, double d2) {
        throw new InternalError();
    }

    public static void intBenchmarkPrimitive(int n, int n2, int n3, boolean bl) {
        throw new InternalError();
    }

    public static void intBenchmarkPrimitiveOptimized(int n, int n2, int n3, boolean bl) {
        throw new InternalError();
    }

    public static void main(String[] stringArray) {
        int n = Integer.parseInt(stringArray[0]);
        int n2 = Integer.parseInt(stringArray[1]);
        int n3 = Integer.parseInt(stringArray[2]);
        String string = stringArray[3];
        int n4 = Integer.parseInt(stringArray[4]);
        double d = new Double(stringArray[5]);
        double d2 = new Double(stringArray[6]);
        boolean bl = stringArray[7].equals("print");
        String string2 = stringArray[8];
        String string3 = stringArray[9];
        if (string2.equals("int")) {
            if (string.equals("primitive")) {
                BenchmarkMatrix2D.intBenchmarkPrimitive(n, n2, n3, bl);
            } else if (string.equals("primitiveOpt")) {
                BenchmarkMatrix2D.intBenchmarkPrimitiveOptimized(n, n2, n3, bl);
            } else {
                BenchmarkMatrix2D.intBenchmark(n, n2, n3, string, bl, n4, d, d2);
            }
        } else if (string2.equals("double")) {
            if (string.equals("primitive")) {
                BenchmarkMatrix2D.doubleBenchmarkPrimitive(n, n2, n3, bl);
            } else if (string.equals("primitiveOpt")) {
                BenchmarkMatrix2D.doubleBenchmarkPrimitiveOptimized(n, n2, n3, bl);
            } else if (string3.equals("mult")) {
                BenchmarkMatrix2D.doubleBenchmarkMult(n, n2, n3, string, bl, n4, d, d2);
            } else {
                BenchmarkMatrix2D.doubleBenchmark(n, n2, n3, string, bl, n4, d, d2);
            }
        }
    }
}

