/*
 * Decompiled with CFR 0.152.
 */
package dr.oldevomodel.substmodel;

import dr.evolution.datatype.Microsatellite;
import dr.inference.model.Parameter;
import dr.inference.model.Variable;
import dr.oldevomodel.substmodel.FrequencyModel;
import dr.oldevomodel.substmodel.OnePhaseModel;
import java.util.ArrayList;

public class LinearBiasModel
extends OnePhaseModel {
    private Parameter biasConst;
    private Parameter biasLin;
    private ArrayList<Variable<Double>> submodelParameters = null;
    private boolean estimateSubmodelParams = false;
    private boolean updateSubmodelRates = false;
    private boolean inLogitSpace = false;
    public static final double delta = 1.0E-15;
    public static final String LINEAR_BIAS_MODEL = "LINEARBIASModel";

    public LinearBiasModel(Microsatellite microsatellite, FrequencyModel frequencyModel, OnePhaseModel onePhaseModel, Parameter parameter, Parameter parameter2, boolean bl, boolean bl2, boolean bl3) {
        super(LINEAR_BIAS_MODEL, microsatellite, frequencyModel, null);
        this.isNested = bl3;
        this.subModel = onePhaseModel;
        this.estimateSubmodelParams = bl2;
        if (this.estimateSubmodelParams) {
            this.submodelParameters = new ArrayList();
            for (int i = 0; i < this.subModel.getNestedParameterCount(); ++i) {
                if (this.isNested) {
                    this.addVariable(this.subModel.getNestedParameter(i));
                }
                this.addParam(this.subModel.getNestedParameter(i));
                this.submodelParameters.add(this.subModel.getNestedParameter(i));
            }
            this.updateSubmodelRates = true;
        }
        this.biasConst = parameter != null ? parameter : new Parameter.Default(0.5);
        this.biasLin = parameter2 != null ? parameter2 : new Parameter.Default(0.0);
        this.addParam(this.biasConst);
        this.addParam(this.biasLin);
        this.inLogitSpace = bl;
        this.setupInfinitesimalRates();
        if (frequencyModel == null) {
            this.useStationaryFreqs = true;
            this.computeStationaryDistribution();
        } else {
            this.freqModel = frequencyModel;
        }
        this.addModel(this.freqModel);
    }

    @Override
    protected void handleVariableChangedEvent(Variable variable, int n, Variable.ChangeType changeType) {
        if (this.submodelParameters != null && this.submodelParameters.indexOf((Parameter)variable) != -1) {
            this.updateSubmodelRates = true;
        }
        this.updateMatrix = true;
    }

    @Override
    public void setupInfinitesimalRates() {
        if (this.updateSubmodelRates) {
            this.subModel.setupInfinitesimalRates();
            this.updateSubmodelRates = false;
        }
        double d = this.biasConst.getParameterValue(0);
        double d2 = this.biasLin.getParameterValue(0);
        LinearBiasModel.setupInfinitesimalRates(this.infinitesimalRateMatrix, this.subModel.getInfinitesimalRates(), d, d2, this.stateCount, this.inLogitSpace);
    }

    public static void setupInfinitesimalRates(double[][] dArray, double[][] dArray2, double d, double d2, int n, boolean bl) {
        double d3 = 0.5;
        for (int i = 0; i < n; ++i) {
            double d4 = 0.0;
            d3 = LinearBiasModel.computeExpansionProb(d, d2, i, bl);
            if (d3 < 1.0E-15) {
                System.out.println("changing expan prob from " + d3 + " to " + 1.0E-15 + "\nbiasConst: " + d + ", biasLin: " + d2);
                d3 = 1.0E-15;
            } else if (d3 > 0.999999999999999) {
                System.out.println("changing expan prob from " + d3 + " to " + 0.999999999999999 + "\nbiasConst: " + d + ", biasLin: " + d2);
                d3 = 0.999999999999999;
            }
            if (i - 1 > -1) {
                dArray[i][i - 1] = dArray2[i][i - 1] * (1.0 - d3);
                d4 += dArray[i][i - 1];
            }
            if (i + 1 < n) {
                dArray[i][i + 1] = dArray2[i][i + 1] * d3;
                d4 += dArray[i][i + 1];
            }
            dArray[i][i] = d4 * -1.0;
        }
    }

    public static double computeExpansionProb(double d, double d2, int n, boolean bl) {
        double d3 = 0.5;
        if (bl) {
            double d4 = Math.exp(d + d2 * (double)n);
            d3 = d4 / (1.0 + d4);
        } else {
            d3 = d + d2 * (double)n;
        }
        return d3;
    }

    public Parameter getBiasConstant() {
        return this.biasConst;
    }

    public Parameter getBiasLinearPercent() {
        return this.biasLin;
    }

    public boolean isEstimatingSubmodelParams() {
        return this.estimateSubmodelParams;
    }

    public boolean isInLogitSpace() {
        return this.inLogitSpace;
    }

    public void printDetails() {
        System.out.println("Details of the Linear Bias Model and its paramters:");
        System.out.println("a submodel:                     " + this.isNested);
        System.out.println("in logit space:                 " + this.inLogitSpace);
        System.out.println("has submodel:                   " + this.hasSubmodel());
        if (this.hasSubmodel()) {
            System.out.println("submodel class:                 " + this.subModel.getClass());
        }
        System.out.println("esitmating submodel parameters: " + this.estimateSubmodelParams);
        System.out.println("bias constant:                  " + this.biasConst.getParameterValue(0));
        System.out.println("bias linear coefficient:        " + this.biasLin.getParameterValue(0));
    }
}

