/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.tree;

import dr.evolution.tree.NodeRef;
import dr.evolution.tree.Tree;
import dr.evolution.tree.TreeUtils;
import dr.evomodel.tree.TreeStatistic;
import dr.inference.model.BooleanStatistic;
import java.util.BitSet;
import java.util.HashSet;
import java.util.Set;

public class CompatibilityStatistic
extends TreeStatistic
implements BooleanStatistic {
    private Tree tree;
    private final Set<BitSet> clades;
    private final BitSet intersection;

    public CompatibilityStatistic(String string, Tree tree, Tree tree2) throws TreeUtils.MissingTaxonException {
        super(string);
        this.tree = tree;
        this.intersection = new BitSet(tree.getExternalNodeCount());
        this.clades = new HashSet<BitSet>();
        this.getClades(tree, tree2, tree2.getRoot(), null, this.clades);
        for (int i = 0; i < tree.getTaxonCount(); ++i) {
            String string2 = tree.getTaxonId(i);
            if (tree2.getTaxonIndex(string2) != -1) continue;
            throw new TreeUtils.MissingTaxonException(tree.getTaxon(i));
        }
    }

    @Override
    public void setTree(Tree tree) {
        this.tree = tree;
    }

    @Override
    public Tree getTree() {
        return this.tree;
    }

    @Override
    public int getDimension() {
        return 1;
    }

    @Override
    public double getStatisticValue(int n) {
        return this.getBoolean(n) ? 1.0 : 0.0;
    }

    @Override
    public boolean getBoolean(int n) {
        return this.isCompatible(this.tree, this.tree.getRoot(), null);
    }

    private boolean isCompatible(Tree tree, NodeRef nodeRef, BitSet bitSet) {
        if (tree.isExternal(nodeRef)) {
            bitSet.set(nodeRef.getNumber());
            return true;
        }
        BitSet bitSet2 = new BitSet(tree.getExternalNodeCount());
        for (int i = 0; i < tree.getChildCount(nodeRef); ++i) {
            NodeRef serializable = tree.getChild(nodeRef, i);
            if (this.isCompatible(tree, serializable, bitSet2)) continue;
            return false;
        }
        if (bitSet != null) {
            if (!this.clades.contains(bitSet2)) {
                for (BitSet bitSet3 : this.clades) {
                    this.intersection.clear();
                    this.intersection.or(bitSet3);
                    this.intersection.and(bitSet2);
                    int n = this.intersection.cardinality();
                    if (n == 0 || n == bitSet2.cardinality() || n == bitSet3.cardinality()) continue;
                    return false;
                }
            }
            bitSet.or(bitSet2);
        }
        return true;
    }

    private void getClades(Tree tree, Tree tree2, NodeRef nodeRef, BitSet bitSet, Set<BitSet> set) {
        if (tree2.isExternal(nodeRef)) {
            String string = tree2.getNodeTaxon(nodeRef).getId();
            for (int i = 0; i < tree.getExternalNodeCount(); ++i) {
                NodeRef nodeRef2 = tree.getExternalNode(i);
                if (!string.equals(tree.getNodeTaxon(nodeRef2).getId())) continue;
                bitSet.set(nodeRef2.getNumber());
            }
        } else {
            BitSet bitSet2 = new BitSet(tree2.getExternalNodeCount());
            for (int i = 0; i < tree2.getChildCount(nodeRef); ++i) {
                NodeRef nodeRef3 = tree2.getChild(nodeRef, i);
                this.getClades(tree, tree2, nodeRef3, bitSet2, set);
            }
            if (bitSet != null) {
                bitSet.or(bitSet2);
                set.add(bitSet2);
            }
        }
    }
}

