/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.coalescent;

import dr.evolution.coalescent.TreeIntervals;
import dr.evolution.tree.Tree;
import dr.evomodel.coalescent.MultiLociTreeSet;
import dr.evomodel.coalescent.VDdemographicFunction;
import dr.evomodel.coalescent.demographicmodel.DemographicModel;
import dr.evomodel.tree.TreeModel;
import dr.inference.model.Model;
import dr.inference.model.Parameter;
import dr.inference.model.Variable;
import dr.util.Author;
import dr.util.Citable;
import dr.util.Citation;
import java.util.Arrays;
import java.util.List;

@Deprecated
public class VariableDemographicModel
extends DemographicModel
implements MultiLociTreeSet,
Citable {
    private final Parameter popSizeParameter;
    private final Parameter indicatorParameter;
    private final Type type;
    private final boolean logSpace;
    private final boolean mid;
    private final TreeModel[] trees;
    private VDdemographicFunction demoFunction = null;
    private VDdemographicFunction savedDemoFunction = null;
    private final double[] populationFactors;

    public Type getType() {
        return this.type;
    }

    public Parameter getPopulationValues() {
        return this.popSizeParameter;
    }

    public VariableDemographicModel(TreeModel[] treeModelArray, double[] dArray, Parameter parameter, Parameter parameter2, Type type, boolean bl, boolean bl2) {
        super("variableDemographic");
        this.popSizeParameter = parameter;
        this.indicatorParameter = parameter2;
        this.populationFactors = dArray;
        int n = 0;
        for (TreeModel treeModel : treeModelArray) {
            n += treeModel.getExternalNodeCount() - 1;
            assert (treeModel.getUnits() == treeModelArray[0].getUnits());
        }
        n += type == Type.STEPWISE ? 0 : 1;
        int n2 = parameter.getDimension();
        int n3 = parameter2.getDimension();
        this.type = type;
        this.logSpace = bl;
        this.mid = bl2;
        if (n2 != n) {
            System.err.println("INFO: resetting length of parameter " + parameter.getParameterName() + "(size " + parameter.getSize() + ") in variable demographic model to " + n);
            parameter.setDimension(n);
            parameter.addBounds(new Parameter.DefaultBounds(Double.POSITIVE_INFINITY, 0.0, parameter.getDimension()));
        }
        if (n3 != n - 1) {
            System.err.println("INFO: resetting length of parameter " + parameter2.getParameterName() + " in variable demographic model to " + (n - 1));
            parameter2.setDimension(n - 1);
            parameter2.addBounds(new Parameter.DefaultBounds(1.0, 0.0, parameter2.getDimension()));
        }
        this.trees = treeModelArray;
        for (TreeModel treeModel : treeModelArray) {
            this.addModel(treeModel);
        }
        this.addVariable(parameter2);
        this.addVariable(parameter);
    }

    @Override
    public int nLoci() {
        return this.trees.length;
    }

    @Override
    public Tree getTree(int n) {
        return this.trees[n];
    }

    @Override
    public TreeIntervals getTreeIntervals(int n) {
        return this.getDemographicFunction().getTreeIntervals(n);
    }

    @Override
    public double getPopulationFactor(int n) {
        return this.populationFactors[n];
    }

    @Override
    public void storeTheState() {
    }

    @Override
    public void restoreTheState() {
    }

    @Override
    public VDdemographicFunction getDemographicFunction() {
        if (this.demoFunction == null) {
            this.demoFunction = new VDdemographicFunction(this.trees, this.type, this.indicatorParameter.getParameterValues(), this.popSizeParameter.getParameterValues(), this.logSpace, this.mid);
        } else {
            this.demoFunction.setup(this.trees, this.indicatorParameter.getParameterValues(), this.popSizeParameter.getParameterValues(), this.logSpace, this.mid);
        }
        return this.demoFunction;
    }

    @Override
    protected void handleModelChangedEvent(Model model, Object object, int n) {
        if (this.demoFunction != null) {
            if (this.demoFunction == this.savedDemoFunction) {
                this.demoFunction = new VDdemographicFunction(this.demoFunction);
            }
            for (int i = 0; i < this.trees.length; ++i) {
                if (model == this.trees[i]) {
                    this.demoFunction.treeChanged(i);
                    break;
                }
                assert (i + 1 < this.trees.length);
            }
        }
        super.handleModelChangedEvent(model, object, n);
        this.fireModelChanged(this);
    }

    @Override
    protected final void handleVariableChangedEvent(Variable variable, int n, Variable.ChangeType changeType) {
        super.handleVariableChangedEvent(variable, n, changeType);
        if (this.demoFunction != null) {
            if (this.demoFunction == this.savedDemoFunction) {
                this.demoFunction = new VDdemographicFunction(this.demoFunction);
            }
            this.demoFunction.setDirty();
        }
        this.fireModelChanged(this);
    }

    @Override
    protected void storeState() {
        this.savedDemoFunction = this.demoFunction;
    }

    @Override
    protected void restoreState() {
        this.demoFunction = this.savedDemoFunction;
        this.savedDemoFunction = null;
    }

    @Override
    public Citation.Category getCategory() {
        return Citation.Category.TREE_PRIORS;
    }

    @Override
    public String getDescription() {
        return "Extended Bayesian Skyline multi-locus coalescent model";
    }

    @Override
    public List<Citation> getCitations() {
        return Arrays.asList(new Citation(new Author[]{new Author("J", "Heled"), new Author("AJ", "Drummond")}, "Bayesian inference of population size history from multiple loci", 2008, "BMC Evolutionary Biology", 8, "289", "10.1186/1471-2148-8-289"));
    }

    public static enum Type {
        LINEAR("linear"),
        EXPONENTIAL("exponential"),
        STEPWISE("stepwise");

        String name;

        private Type(String string2) {
            this.name = string2;
        }

        public String toString() {
            return this.name;
        }
    }
}

