/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.branchratemodel;

import dr.evolution.tree.NodeRef;
import dr.evolution.tree.Tree;
import dr.evomodel.branchratemodel.AbstractBranchRateModel;
import dr.inference.model.Model;
import dr.inference.model.Parameter;
import dr.inference.model.Variable;
import dr.xml.AbstractXMLObjectParser;
import dr.xml.ElementRule;
import dr.xml.XMLObject;
import dr.xml.XMLObjectParser;
import dr.xml.XMLParseException;
import dr.xml.XMLSyntaxRule;

public class PassageBranchRateModel
extends AbstractBranchRateModel {
    public static final String PASSAGE_BRANCH_RATE_MODEL = "passageBranchRateModel";
    public static final String EXTERNAL_RATE = "externalRate";
    public static final String INTERNAL_RATE = "internalRate";
    private Parameter internalRateParameter;
    private Parameter externalRateParameter;
    public static XMLObjectParser PARSER = new AbstractXMLObjectParser(){
        private XMLSyntaxRule[] rules = new XMLSyntaxRule[]{new ElementRule("externalRate", Parameter.class, "The molecular evolutionary rate parameter for external branches", false), new ElementRule("internalRate", Parameter.class, "The molecular evolutionary rate parameter for internal branches", false)};

        @Override
        public String getParserName() {
            return PassageBranchRateModel.PASSAGE_BRANCH_RATE_MODEL;
        }

        @Override
        public Object parseXMLObject(XMLObject xMLObject) throws XMLParseException {
            Parameter parameter = (Parameter)xMLObject.getElementFirstChild(PassageBranchRateModel.EXTERNAL_RATE);
            Parameter parameter2 = (Parameter)xMLObject.getElementFirstChild(PassageBranchRateModel.INTERNAL_RATE);
            PassageBranchRateModel passageBranchRateModel = new PassageBranchRateModel(parameter, parameter2);
            System.out.println("Using tip branch rate model.");
            return passageBranchRateModel;
        }

        @Override
        public String getParserDescription() {
            return "This element returns a branch rate model that has a different rate for external branches than internal.";
        }

        @Override
        public Class getReturnType() {
            return PassageBranchRateModel.class;
        }

        @Override
        public XMLSyntaxRule[] getSyntaxRules() {
            return this.rules;
        }
    };

    public PassageBranchRateModel(Parameter parameter, Parameter parameter2) {
        super(PASSAGE_BRANCH_RATE_MODEL);
        this.internalRateParameter = parameter2;
        this.addVariable(parameter2);
        this.externalRateParameter = parameter;
        this.addVariable(parameter);
    }

    @Override
    public void handleModelChangedEvent(Model model, Object object, int n) {
        this.fireModelChanged();
    }

    @Override
    protected final void handleVariableChangedEvent(Variable variable, int n, Variable.ChangeType changeType) {
        this.fireModelChanged();
    }

    @Override
    protected void storeState() {
    }

    @Override
    protected void restoreState() {
    }

    @Override
    protected void acceptState() {
    }

    @Override
    public double getBranchRate(Tree tree, NodeRef nodeRef) {
        if (tree.isExternal(nodeRef)) {
            double d = tree.getNodeHeight(nodeRef);
            double d2 = tree.getBranchLength(nodeRef);
            double d3 = this.externalRateParameter.getParameterValue(0);
            double d4 = this.internalRateParameter.getParameterValue(0);
            return (d3 * d2 + d4 * d) / (d2 + d);
        }
        return this.internalRateParameter.getParameterValue(0);
    }
}

