/*
 * Decompiled with CFR 0.152.
 */
package dr.evolution.tree.treemetrics;

import dr.evolution.tree.NodeRef;
import dr.evolution.tree.Tree;
import dr.evolution.tree.treemetrics.TreeMetric;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class SteelPennyPathDifferenceMetric
implements TreeMetric {
    public static TreeMetric.Type TYPE = TreeMetric.Type.STEEL_PENNY;
    private Tree focalTree;
    private int dim;
    private double[] focalPath;
    private final boolean fixedFocalTree;

    public SteelPennyPathDifferenceMetric() {
        this.fixedFocalTree = false;
    }

    public SteelPennyPathDifferenceMetric(Tree tree) {
        this.focalTree = tree;
        this.fixedFocalTree = true;
        this.dim = tree.getExternalNodeCount() * tree.getExternalNodeCount();
        this.focalPath = new double[this.dim];
        this.traverse(this.focalTree, this.focalTree.getRoot(), this.focalPath);
    }

    @Override
    public double getMetric(Tree tree, Tree tree2) {
        TreeMetric.Utils.checkTreeTaxa(tree, tree2);
        if (tree != this.focalTree) {
            if (this.fixedFocalTree) {
                throw new RuntimeException("Focal tree is different from that set in the constructor.");
            }
            this.focalTree = tree;
            if (this.focalPath == null) {
                this.dim = this.focalTree.getExternalNodeCount() * this.focalTree.getExternalNodeCount();
                this.focalPath = new double[this.dim];
            }
            this.traverse(this.focalTree, this.focalTree.getRoot(), this.focalPath);
        }
        double[] dArray = new double[this.dim];
        this.traverse(tree2, tree2.getRoot(), dArray);
        int n = tree.getExternalNodeCount();
        double d = 0.0;
        for (int i = 0; i < n; ++i) {
            for (int j = i + 1; j < n; ++j) {
                int n2 = i * n + j;
                d += Math.pow(this.focalPath[n2] - dArray[n2], 2.0);
            }
        }
        d = Math.sqrt(d);
        return d;
    }

    private Set<NodeRef> traverse(Tree tree, NodeRef nodeRef, double[] dArray) {
        NodeRef nodeRef2 = tree.getChild(nodeRef, 0);
        NodeRef nodeRef3 = tree.getChild(nodeRef, 1);
        Set<NodeRef> set = null;
        Set<NodeRef> set2 = null;
        set = !tree.isExternal(nodeRef2) ? this.traverse(tree, nodeRef2, dArray) : Collections.singleton(nodeRef2);
        set2 = !tree.isExternal(nodeRef3) ? this.traverse(tree, nodeRef3, dArray) : Collections.singleton(nodeRef3);
        for (NodeRef nodeRef4 : set) {
            for (NodeRef nodeRef5 : set2) {
                int n = nodeRef4.getNumber() < nodeRef5.getNumber() ? nodeRef4.getNumber() * tree.getExternalNodeCount() + nodeRef5.getNumber() : nodeRef5.getNumber() * tree.getExternalNodeCount() + nodeRef4.getNumber();
                dArray[n] = tree.getNodeHeight(nodeRef) * 2.0 - tree.getNodeHeight(nodeRef4) - tree.getNodeHeight(nodeRef5);
            }
        }
        HashSet hashSet = new HashSet();
        hashSet.addAll(set);
        hashSet.addAll(set2);
        return hashSet;
    }

    @Override
    public TreeMetric.Type getType() {
        return TYPE;
    }

    public String toString() {
        return this.getType().getShortName();
    }
}

