/*
 * Decompiled with CFR 0.152.
 */
package org.vikamine.kernel.subgroup.quality.functions;

import org.vikamine.kernel.data.DataRecord;
import org.vikamine.kernel.subgroup.ISubgroup;
import org.vikamine.kernel.subgroup.quality.IQualityFunction;

public class SimplicityFavoringQF
implements IQualityFunction {
    private static final String ID = "SimplicityFavoringQF";
    private final IQualityFunction wrappedQualityFunction;

    public SimplicityFavoringQF(IQualityFunction wrapped) {
        this.wrappedQualityFunction = wrapped;
    }

    @Override
    public String getID() {
        return "SimplicityFavoringQF(" + this.wrappedQualityFunction.getID() + ")";
    }

    @Override
    public String getName() {
        return String.valueOf(this.wrappedQualityFunction.getName()) + " (simplicity)";
    }

    @Override
    public boolean isApplicable(ISubgroup<DataRecord> subgroup) {
        return this.wrappedQualityFunction.isApplicable(subgroup);
    }

    @Override
    public double evaluate(ISubgroup<DataRecord> subgroup) {
        return this.wrappedQualityFunction.evaluate(subgroup) / (double)subgroup.getDescription().getSelectors().size();
    }

    @Override
    public SimplicityFavoringQF clone() {
        return new SimplicityFavoringQF(this.wrappedQualityFunction.clone());
    }
}

