/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.memory.trailing.trail.chunck;

import org.chocosolver.memory.trailing.StoredLong;
import org.chocosolver.memory.trailing.trail.IStoredLongTrail;
import org.chocosolver.memory.trailing.trail.chunck.ChunckedTrail;
import org.chocosolver.memory.trailing.trail.chunck.LongWorld;

public class ChunckedLongTrail
extends ChunckedTrail<LongWorld>
implements IStoredLongTrail {
    private final int ws;
    private final double loadfactor;

    public ChunckedLongTrail(int ws, int nbWorlds, double loadfactor) {
        this.worlds = new LongWorld[nbWorlds];
        this.ws = ws;
        this.loadfactor = loadfactor;
        this.current = new LongWorld(ws, loadfactor);
        ((LongWorld[])this.worlds)[0] = this.current;
    }

    @Override
    public void worldPush(int worldIndex) {
        if (((LongWorld[])this.worlds)[worldIndex] == null) {
            this.current = new LongWorld(this.ws, this.loadfactor);
            ((LongWorld[])this.worlds)[worldIndex] = (LongWorld)this.current;
        } else {
            this.current = ((LongWorld[])this.worlds)[worldIndex];
            ((LongWorld)this.current).clear();
        }
        if (worldIndex == ((LongWorld[])this.worlds).length - 1) {
            this.resizeWorlds();
        }
    }

    private void resizeWorlds() {
        int newCapacity = (int)((double)((LongWorld[])this.worlds).length * this.loadfactor);
        LongWorld[] tmp = new LongWorld[newCapacity];
        System.arraycopy(this.worlds, 0, tmp, 0, ((LongWorld[])this.worlds).length);
        this.worlds = tmp;
    }

    @Override
    public void savePreviousState(StoredLong v, long oldValue, int oldStamp) {
        ((LongWorld)this.current).savePreviousState(v, oldValue, oldStamp);
    }
}

