/*
 * Decompiled with CFR 0.152.
 */
package choco.kernel.solver.variables;

import choco.kernel.common.HashCoding;
import choco.kernel.common.util.iterators.DisposableIterator;
import choco.kernel.memory.structure.APartiallyStoredCstrList;
import choco.kernel.memory.structure.PartiallyStoredIntVector;
import choco.kernel.memory.structure.PartiallyStoredVector;
import choco.kernel.solver.Solver;
import choco.kernel.solver.branch.Extension;
import choco.kernel.solver.constraints.SConstraint;
import choco.kernel.solver.propagation.PropagationEngine;
import choco.kernel.solver.propagation.event.VarEvent;
import choco.kernel.solver.variables.Var;
import java.util.HashMap;

public abstract class AbstractVar
implements Var {
    protected PropagationEngine propagationEngine;
    protected String name;
    private long index;
    protected VarEvent<? extends Var> event;
    protected APartiallyStoredCstrList<? extends SConstraint> constraints;
    private static int ABSTRACTVAR_EXTENSIONS_NB = 0;
    private static final HashMap<String, Integer> REGISTERED_ABSTRACTVAR_EXTENSIONS = new HashMap();
    public Extension[] extensions = new Extension[4];

    public static int getAbstractVarExtensionNumber(String name) {
        Integer ind = REGISTERED_ABSTRACTVAR_EXTENSIONS.get(name);
        if (ind == null) {
            ind = ABSTRACTVAR_EXTENSIONS_NB++;
            REGISTERED_ABSTRACTVAR_EXTENSIONS.put(name, ind);
        }
        return ind;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public AbstractVar(Solver solver, String name, APartiallyStoredCstrList<? extends SConstraint> constraints) {
        this.propagationEngine = solver.getPropagationEngine();
        this.name = name;
        this.constraints = constraints;
        this.index = solver.getIndexfactory().getIndex();
    }

    public int hashCode() {
        return HashCoding.hashCodeMe(new Object[]{this.index});
    }

    @Override
    public final long getIndex() {
        return this.index;
    }

    @Override
    public final int getPriority() {
        return this.constraints.getPriority();
    }

    @Override
    public void addExtension(int extensionNumber) {
        if (extensionNumber >= this.extensions.length) {
            Extension[] newArray = new Extension[this.extensions.length * 2];
            System.arraycopy(this.extensions, 0, newArray, 0, this.extensions.length);
            this.extensions = newArray;
        }
        this.extensions[extensionNumber] = new Extension();
    }

    @Override
    public Extension getExtension(int extensionNumber) {
        return this.extensions[extensionNumber];
    }

    public String toString() {
        return this.name;
    }

    @Override
    public VarEvent<? extends Var> getEvent() {
        return this.event;
    }

    @Override
    public SConstraint getConstraint(int i) {
        return this.constraints.getConstraint(i);
    }

    @Override
    public int getNbConstraints() {
        return this.constraints.getNbConstraints();
    }

    @Override
    public PartiallyStoredVector<? extends SConstraint> getConstraintVector() {
        return this.constraints.getConstraintVector();
    }

    @Override
    public PartiallyStoredIntVector getIndexVector() {
        return this.constraints.getIndexVector();
    }

    @Override
    public int getVarIndex(int constraintIndex) {
        return this.constraints.getConstraintIndex(constraintIndex);
    }

    public void eraseConstraint(SConstraint c) {
        this.constraints.eraseConstraint(c);
    }

    @Override
    public int addConstraint(SConstraint c, int varIdx, boolean dynamicAddition) {
        return this.constraints.addConstraint(c, varIdx, dynamicAddition);
    }

    @Override
    public DisposableIterator<SConstraint> getConstraintsIterator() {
        return this.constraints.getConstraintsIterator();
    }
}

