/*
 * Decompiled with CFR 0.152.
 */
package org.af.gMCP.gui;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URLEncoder;
import java.util.Hashtable;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.text.JTextComponent;
import org.af.commons.errorhandling.ErrorHandler;
import org.af.commons.errorhandling.HTTPPoster;
import org.af.commons.logging.ApplicationLog;
import org.af.commons.logging.LoggingSystem;
import org.af.commons.threading.SafeSwingWorker;
import org.af.commons.tools.StringTools;
import org.af.commons.widgets.GUIToolKit;
import org.af.commons.widgets.RightClickTextMenuListener;
import org.af.gMCP.config.Configuration;
import org.af.gMCP.gui.RControl;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.log4j.FileAppender;
import org.apache.log4j.Logger;

public abstract class ErrorDialogChooseLevelBase
extends JDialog
implements ActionListener {
    String[] reportLevels = new String[]{"Report no error.", "Minimal: Just the stack trace + version + OS type", "Default: The most important information", "Maximal: Include more information about the system"};
    protected JComboBox jcbReportLevel;
    protected JCheckBox jcbScreenshot = new JCheckBox("Send screenshot of GUI window");
    protected static Log logger = LogFactory.getLog(ErrorDialogChooseLevelBase.class);
    public JButton send = new JButton("Send directly");
    public JButton emailClient = new JButton("Open email client");
    public JButton createZip = new JButton("Save report file");
    public JButton close = new JButton("Ignore and close");
    protected final boolean fatal;
    protected String informMsg = "";
    protected final String msg;
    protected String message = "";
    protected String stacktrace = "";
    protected final Object e;
    protected ApplicationLog al;
    String subjectShort;
    String subjectLong;
    JTextArea jta;

    public ErrorDialogChooseLevelBase(String msg, Object e, boolean fatal) {
        super(GUIToolKit.findActiveFrame(), "Error report", true);
        int rLevel;
        this.fatal = fatal;
        this.e = e;
        if (e != null && e instanceof Throwable) {
            ((Throwable)e).printStackTrace();
        }
        this.msg = msg;
        if (e != null) {
            if (e instanceof Throwable) {
                this.message = ((Throwable)e).getMessage();
                this.stacktrace = ExceptionUtils.getStackTrace((Throwable)((Throwable)e));
            } else {
                this.message = e.toString();
            }
        }
        if (this.message == null) {
            this.message = "";
        }
        this.al = LoggingSystem.getInstance().getApplicationLog();
        String cols = "5dlu, pref, 5dlu, fill:pref:grow, 5dlu, pref, 5dlu, pref, 5dlu, pref, 5dlu, pref, 5dlu";
        String rows = "5dlu, pref, 5dlu, pref, 5dlu, fill:200dlu:grow, 5dlu, pref, 5dlu, pref, 5dlu, pref, 5dlu";
        FormLayout layout = new FormLayout(cols, rows);
        this.getContentPane().setLayout((LayoutManager)layout);
        CellConstraints cc = new CellConstraints();
        this.jcbReportLevel = new JComboBox<String>(this.reportLevels);
        try {
            rLevel = Integer.parseInt(Configuration.getInstance().getClassProperty(this.getClass(), "reportLevel", "2"));
        }
        catch (Exception ex) {
            rLevel = 2;
        }
        this.jcbReportLevel.setSelectedIndex(rLevel);
        this.jcbReportLevel.addActionListener(this);
        this.subjectShort = this.getSubjectShort();
        this.jta = new JTextArea(this.getErrorReport(this.jcbReportLevel.getSelectedIndex()));
        this.jta.setCaretPosition(0);
        this.jta.setFont(new Font("Monospaced", 0, 10));
        this.jta.setLineWrap(true);
        this.jta.setWrapStyleWord(true);
        this.jta.setMargin(new Insets(4, 4, 4, 4));
        this.jta.addMouseListener((MouseListener)new RightClickTextMenuListener((JTextComponent)this.jta));
        this.subjectLong = this.subjectShort + " : " + (this.message.length() < 40 ? this.message : this.message.substring(0, 37) + "...");
        int row = 2;
        JTextArea jlabel = new JTextArea("We are sorry that an error occurred.\nWe would be pleased, if you could send the report below to " + ErrorHandler.getInstance().getDeveloperAddress() + " :");
        jlabel.setOpaque(false);
        jlabel.setEditable(false);
        jlabel.setFont(jlabel.getFont().deriveFont(jlabel.getFont().getStyle() ^ 1));
        this.getContentPane().add((Component)jlabel, cc.xyw(2, row, 11));
        this.getContentPane().add((Component)this.jcbReportLevel, cc.xyw(2, row += 2, 11));
        JScrollPane jsp = new JScrollPane(this.jta);
        this.getContentPane().add((Component)jsp, cc.xyw(2, row += 2, 11));
        this.getContentPane().add((Component)this.send, cc.xy(6, row += 2));
        this.send.addActionListener(this);
        this.getContentPane().add((Component)this.emailClient, cc.xy(8, row));
        this.emailClient.addActionListener(this);
        this.getContentPane().add((Component)this.createZip, cc.xy(10, row));
        this.createZip.addActionListener(this);
        this.getContentPane().add((Component)this.close, cc.xy(12, row));
        this.close.addActionListener(this);
    }

    public abstract String getSubjectShort();

    public void showDialog() {
        this.pack();
        this.setSize(900, 700);
        this.setVisible(true);
    }

    void openEmailClient() {
        try {
            String mailto = "mailto:" + ErrorHandler.getInstance().getDeveloperAddress() + "?subject=" + URLEncoder.encode(this.subjectLong, "UTF-8").replace("+", "%20") + "&body=" + URLEncoder.encode(this.jta.getText(), "UTF-8").replace("+", "%20");
            try {
                URI uriMailTo = new URI(mailto);
                Method main = Class.forName("java.awt.Desktop").getDeclaredMethod("getDesktop", new Class[0]);
                Object obj = main.invoke((Object)new Object[0], new Object[0]);
                Method second = obj.getClass().getDeclaredMethod("mail", URI.class);
                second.invoke(obj, uriMailTo);
            }
            catch (Exception e) {
                logger.warn((Object)"No Desktop class in Java 5 or URI error.", (Throwable)e);
            }
            this.dispose();
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
    }

    protected String getSep(String title) {
        return "\n************************* " + title + " *************************\n\n";
    }

    protected abstract String getErrorReport(int var1);

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.close) {
            this.dispose();
            return;
        }
        if (e.getSource() == this.send) {
            SafeSwingWorker<Void, Void> worker = new SafeSwingWorker<Void, Void>(){

                protected Void doInBackground() throws Exception {
                    new HTTPPoster().post(ErrorHandler.getInstance().getReportURL(), ErrorDialogChooseLevelBase.this.getInfoTable(), ErrorDialogChooseLevelBase.this.getAttachedFiles());
                    return null;
                }

                protected void onFailure(Throwable t) {
                    String msg = "Could not connect to server and send report.\n(" + t.getMessage() + ")\nPlease send mail manually!";
                    logger.error((Object)msg, t);
                    JOptionPane.showMessageDialog(ErrorDialogChooseLevelBase.this, msg, "Could not send report", 0);
                    ErrorDialogChooseLevelBase.this.openEmailClient();
                }

                protected void onSuccess(Void result) {
                    ErrorDialogChooseLevelBase.this.dispose();
                    JOptionPane.showMessageDialog(ErrorDialogChooseLevelBase.this, "Report was sent.");
                }
            };
            worker.execute();
            return;
        }
        if (e.getSource() == this.emailClient) {
            this.openEmailClient();
            return;
        }
        if (e.getSource() == this.createZip) {
            try {
                int answer;
                File f;
                JFileChooser fc = new JFileChooser(Configuration.getInstance().getClassProperty(this.getClass(), "ReportSaveDirectory"));
                fc.setDialogType(1);
                fc.setFileSelectionMode(0);
                int returnVal = fc.showSaveDialog(this);
                if (returnVal == 0) {
                    f = fc.getSelectedFile();
                    Configuration.getInstance().setClassProperty(this.getClass(), "ReportSaveDirectory", f.getParent());
                    if (!f.getName().toLowerCase().endsWith(".txt")) {
                        f = new File(f.getAbsolutePath() + ".txt");
                    }
                } else {
                    return;
                }
                if (f.exists() && (answer = JOptionPane.showConfirmDialog(this, "File '" + f.getAbsolutePath() + "' exists.\n Do you want to overwrite it?", "File exists", 2)) != 0) {
                    return;
                }
                PrintWriter out = new PrintWriter(f.getAbsolutePath());
                out.println(this.jta.getText());
                out.close();
                this.dispose();
                return;
            }
            catch (FileNotFoundException e1) {
                JOptionPane.showMessageDialog(this, "Error saving report:\n" + e1.getMessage(), "Error saving error report - oh my", 0);
                e1.printStackTrace();
            }
        }
        Configuration.getInstance().setClassProperty(this.getClass(), "reportLevel", "" + this.jcbReportLevel.getSelectedIndex());
        this.jta.setText(this.getErrorReport(this.jcbReportLevel.getSelectedIndex()));
        this.jta.setCaretPosition(0);
    }

    protected Hashtable<String, String> getInfoTable() {
        Hashtable<String, String> table = new Hashtable<String, String>();
        table.put("Bugreport", this.jta.getText());
        table.put("Subject", this.subjectLong);
        return table;
    }

    protected Hashtable<String, File> getAttachedFiles() throws IOException {
        return new Hashtable<String, File>();
    }

    protected String getRErrorMessage() {
        return StringTools.collapseStringArray((String[])RControl.getR().eval("paste(geterrmessage(), collapse=\"\\n\")").asRChar().getData());
    }

    protected String getROptions() {
        return StringTools.collapseStringArray((String[])RControl.getR().eval("paste(capture.output(options()), collapse=\"\\n\")").asRChar().getData());
    }

    protected String getRSessionInfo() {
        return StringTools.collapseStringArray((String[])RControl.getR().eval("paste(capture.output(sessionInfo()), collapse=\"\\n\")").asRChar().getData());
    }

    protected String getSystemInfo() {
        return this.al.getSystemInfo();
    }

    protected String getTraceBack() {
        return StringTools.collapseStringArray((String[])RControl.getR().eval("paste(capture.output(traceback()), collapse=\"\\n\")").asRChar().getData());
    }

    public File getReadableLogFile() {
        return new File(this.getReadableLogFileAppender().getFile());
    }

    public FileAppender getReadableLogFileAppender() {
        return (FileAppender)Logger.getRootLogger().getAppender("READABLE_FILE");
    }

    public File screen() throws IOException {
        return null;
    }
}

