/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.regression;

import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.regression.NewRegressionBase;
import com.hp.hpl.jena.regression.Regression;
import com.hp.hpl.jena.vocabulary.RDF;
import junit.framework.TestSuite;

public class NewRegressionAddAndContains
extends NewRegressionBase {
    protected Model m;
    protected Resource S;
    protected Property P;

    public NewRegressionAddAndContains(String name) {
        super(name);
    }

    public static TestSuite suite() {
        return new TestSuite(NewRegressionAddAndContains.class);
    }

    protected Model getModel() {
        return ModelFactory.createDefaultModel();
    }

    public void setUp() {
        this.m = this.getModel();
        this.S = this.m.createResource("http://nowhere.man/subject");
        this.P = this.m.createProperty("http://nowhere.man/predicate");
    }

    public void tearDown() {
        this.m = null;
        this.S = null;
        this.P = null;
    }

    public void testEmpty() {
        NewRegressionAddAndContains.assertFalse((boolean)this.m.contains(this.S, this.P, true));
        NewRegressionAddAndContains.assertFalse((boolean)this.m.contains(this.S, this.P, this.m.createResource()));
        NewRegressionAddAndContains.assertFalse((boolean)this.m.contains(this.S, this.P, 1L));
        NewRegressionAddAndContains.assertFalse((boolean)this.m.contains(this.S, this.P, 2L));
        NewRegressionAddAndContains.assertFalse((boolean)this.m.contains(this.S, this.P, -1L));
        NewRegressionAddAndContains.assertFalse((boolean)this.m.contains(this.S, this.P, -2L));
        NewRegressionAddAndContains.assertFalse((boolean)this.m.contains(this.S, this.P, '!'));
        NewRegressionAddAndContains.assertFalse((boolean)this.m.contains(this.S, this.P, 123.456f));
        NewRegressionAddAndContains.assertFalse((boolean)this.m.contains(this.S, this.P, -123.456));
        NewRegressionAddAndContains.assertFalse((boolean)this.m.contains(this.S, this.P, new Regression.LitTestObj(12345L)));
        NewRegressionAddAndContains.assertFalse((boolean)this.m.contains(this.S, this.P, "test string"));
        NewRegressionAddAndContains.assertFalse((boolean)this.m.contains(this.S, this.P, "test string", "en"));
    }

    public void testAddContainsResource() {
        Resource r = this.m.createResource();
        this.m.add(this.S, this.P, r);
        NewRegressionAddAndContains.assertTrue((boolean)this.m.contains(this.S, this.P, r));
    }

    public void testAddContainsBoolean() {
        this.m.add(this.S, this.P, true);
        NewRegressionAddAndContains.assertTrue((boolean)this.m.contains(this.S, this.P, true));
    }

    public void testAddContainsByte() {
        this.m.add(this.S, this.P, 1L);
        NewRegressionAddAndContains.assertTrue((boolean)this.m.contains(this.S, this.P, 1L));
    }

    public void testAddContainsShort() {
        this.m.add(this.S, this.P, 2L);
        NewRegressionAddAndContains.assertTrue((boolean)this.m.contains(this.S, this.P, 2L));
    }

    public void testAddContainsInt() {
        this.m.add(this.S, this.P, -1L);
        NewRegressionAddAndContains.assertTrue((boolean)this.m.contains(this.S, this.P, -1L));
    }

    public void testAddContainsLong() {
        this.m.add(this.S, this.P, -2L);
        NewRegressionAddAndContains.assertTrue((boolean)this.m.contains(this.S, this.P, -2L));
    }

    public void testAddContainsChar() {
        this.m.add(this.S, this.P, '!');
        NewRegressionAddAndContains.assertTrue((boolean)this.m.contains(this.S, this.P, '!'));
    }

    public void testAddContainsFloat() {
        this.m.add(this.S, this.P, 123.456f);
        NewRegressionAddAndContains.assertTrue((boolean)this.m.contains(this.S, this.P, 123.456f));
    }

    public void testAddContainsDouble() {
        this.m.add(this.S, this.P, -123.456);
        NewRegressionAddAndContains.assertTrue((boolean)this.m.contains(this.S, this.P, -123.456));
    }

    public void testAddContainsObject() {
        Regression.LitTestObj O = new Regression.LitTestObj(12345L);
        this.m.add(this.S, this.P, O);
        NewRegressionAddAndContains.assertTrue((boolean)this.m.contains(this.S, this.P, O));
    }

    public void testAddContainsPlainString() {
        this.m.add(this.S, this.P, "test string");
        NewRegressionAddAndContains.assertTrue((boolean)this.m.contains(this.S, this.P, "test string"));
        NewRegressionAddAndContains.assertFalse((boolean)this.m.contains(this.S, this.P, "test string", "en"));
    }

    public void testAddContainsLanguagedString() {
        this.m.add(this.S, this.P, "test string", "en");
        NewRegressionAddAndContains.assertFalse((boolean)this.m.contains(this.S, this.P, "test string"));
        NewRegressionAddAndContains.assertTrue((boolean)this.m.contains(this.S, this.P, "test string", "en"));
    }

    public void testAddContainLiteralByStatement() {
        Literal L = this.m.createLiteral(210L);
        Statement s = this.m.createStatement(this.S, RDF.value, L);
        NewRegressionAddAndContains.assertTrue((boolean)this.m.add(s).contains(s));
        NewRegressionAddAndContains.assertTrue((boolean)this.m.contains(this.S, RDF.value));
    }

    public void testAddDuplicateLeavesSizeSame() {
        Statement s = this.m.createStatement(this.S, RDF.value, "something");
        this.m.add(s);
        long size = this.m.size();
        this.m.add(s);
        NewRegressionAddAndContains.assertEquals((long)size, (long)this.m.size());
    }
}

