/*
 * Decompiled with CFR 0.152.
 */
package javalain.algorithmegenetique;

public class ParametreAG {
    public static final int RANG = 0;
    public static final int TOURNOI = 1;
    public static final int ROULETTE_PIPEE = 2;
    public static final int RESTE_STOCHASTIQUE = 3;
    public static final String GGA = "Generational GA";
    public static final String SSGA = "Steady-State GA";
    public static final String ES = "Evolution Strategy";
    public static final String MOGA = "MultiObjective GA";
    public static final String NPGA = "Niched Pareto GA";
    public static final String NSGA_2 = "Nondominated Sorting GA 2";
    public static final String VEGA = "Vector Evaluated GA";
    private static final int ENFANT_PARENT = 20;
    public static final int ALEATOIRE = 21;
    public static final int LES_PLUS_MAUVAIS = 22;
    public static final int TOURNOI_INVERSE = 23;
    public static final int LES_PLUS_VIEUX = 24;
    public static final int PERSO = 25;
    private String nom;
    private String algorithme;
    private double tauxMutation;
    private double tauxCroisement;
    private int selection;
    private int nbPartTournoi;
    private boolean scaling;
    private boolean sharing;
    private double alpha;
    private double sigmaShare;
    private boolean crowding;
    private boolean croisementRestreint;
    private boolean elitisme;
    private int nbMeilleurs;
    private int remplacement;
    private int nbOverlap;
    private int tdom;

    public ParametreAG(String s) {
        this.nom = s;
        this.algorithme = GGA;
        this.tauxMutation = 0.05;
        this.tauxCroisement = 0.65;
        this.selection = 1;
        this.nbPartTournoi = 3;
        this.scaling = false;
        this.sharing = false;
        this.alpha = 0.5;
        this.sigmaShare = 0.0;
        this.crowding = false;
        this.croisementRestreint = false;
        this.elitisme = false;
        this.nbMeilleurs = 1;
        this.remplacement = 22;
        this.nbOverlap = 1;
        this.tdom = 10;
    }

    public String getNom() {
        return this.nom;
    }

    public void setAlgorithme(String type_algo) {
        if (!(type_algo.equals(GGA) || type_algo.equals(SSGA) || type_algo.equals(ES) || type_algo.equals(MOGA) || type_algo.equals(NPGA) || type_algo.equals(NSGA_2) || type_algo.equals(VEGA))) {
            throw new IllegalArgumentException("ParametreAG, setAlgorithme (String type_algo) : algorithme inconnu.");
        }
        this.algorithme = type_algo;
    }

    public String getAlgorithme() {
        return this.algorithme;
    }

    public void setTauxMutation(double d) {
        if (d < 0.0 || d > 1.0) {
            throw new IllegalArgumentException("ParametreAG, setTauxMutation (double d) : le taux de mutation doit etre compris entre 0 et 1.");
        }
        this.tauxMutation = d;
    }

    public double getTauxMutation() {
        return this.tauxMutation;
    }

    public void setTauxCroisement(double d) {
        if (d < 0.0 || d > 1.0) {
            throw new IllegalArgumentException("ParametreAG, setTauxCroisement (double d) : le taux de croisement doit etre compris entre 0 et 1.");
        }
        this.tauxCroisement = d;
    }

    public double getTauxCroisement() {
        return this.tauxCroisement;
    }

    public void setSelection(int sel) {
        if (sel != 0 && sel != 1 && sel != 2 && sel != 3) {
            throw new IllegalArgumentException("ParametreAG, setSelection (int sel) : mode de selection inconnu.");
        }
        this.selection = sel;
    }

    public int getSelection() {
        if (this.algorithme.equals(NPGA)) {
            return 1;
        }
        if (this.algorithme.equals(MOGA)) {
            return 0;
        }
        if (this.algorithme.equals(VEGA) && this.selection == 3) {
            return 2;
        }
        return this.selection;
    }

    public void setNbPartTournoi(int i) {
        if (i < 2) {
            throw new IllegalArgumentException("ParametreAG, setNbPartTournoi (int i) : le nombre de participants au tournoi doit etre superieur a 1.");
        }
        this.nbPartTournoi = i;
    }

    public int getNbPartTournoi() {
        return this.nbPartTournoi;
    }

    public void setScaling(boolean b) {
        this.scaling = b;
    }

    public boolean getScaling() {
        if (this.algorithme.equals(SSGA) || this.algorithme.equals(VEGA)) {
            return false;
        }
        return this.scaling;
    }

    public void setSharing(boolean b) {
        this.sharing = b;
    }

    public boolean getSharing() {
        if (this.algorithme.equals(NPGA)) {
            return true;
        }
        if (this.algorithme.equals(VEGA)) {
            return false;
        }
        return this.sharing;
    }

    public void setAlpha(double d) {
        if (d < 0.0) {
            throw new IllegalArgumentException("ParametreAG, setAlpha (double d) : alpha doit etre > 0.0.");
        }
        this.alpha = d;
    }

    public double getAlpha() {
        return this.alpha;
    }

    public void setSigmaShare(double d) {
        if (d < 0.0) {
            throw new IllegalArgumentException("ParametreAG, setSigmaShare (double d) : sigmashare doit etre > 0.0.");
        }
        this.sigmaShare = d;
    }

    public double getSigmaShare() {
        return this.sigmaShare;
    }

    public void setCrowding(boolean b) {
        this.crowding = b;
    }

    public boolean getCrowding() {
        return this.crowding;
    }

    public void setCroisementRestreint(boolean b) {
        this.croisementRestreint = b;
    }

    public boolean getCroisementRestreint() {
        return this.croisementRestreint;
    }

    public void setElitisme(boolean b) {
        this.elitisme = b;
    }

    public boolean getElitisme() {
        if (this.algorithme.equals(GGA)) {
            return this.elitisme;
        }
        return false;
    }

    public void setNbMeilleurs(int i) {
        if (i < 1) {
            throw new IllegalArgumentException("ParametreAG, setNbMeilleurs (int i) : le nombre de meilleurs individus doit etre superieur a 0.");
        }
        this.nbMeilleurs = i;
    }

    public int getNbMeilleurs() {
        return this.nbMeilleurs;
    }

    public void setRemplacement(int rempl) {
        if (rempl != 21 && rempl != 22 && rempl != 23 && rempl != 24 && rempl != 25) {
            throw new IllegalArgumentException("ParametreAG, setRemplacement (int rempl) : m\u00e9thode de remplacement incorrecte.");
        }
        this.remplacement = rempl;
    }

    public int getRemplacement() {
        if (this.algorithme.equals(SSGA)) {
            return this.remplacement;
        }
        return 20;
    }

    public void setNbOverlap(int i) {
        if (i < 1) {
            throw new IllegalArgumentException("ParametreAG, setNbOverlap (int i) : le nombre d'individus supplementaires doit etre superieur a 0.");
        }
        this.nbOverlap = i;
    }

    public int getNbOverlap() {
        return this.nbOverlap;
    }

    public void setTdom(int i) {
        if (i <= 0) {
            throw new IllegalArgumentException("ParametreAG, setTdom (int i) : la taille de la sous population de NPGA doit etre > 0.");
        }
        this.tdom = i;
    }

    public int getTdom() {
        return this.tdom;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("-----------------------\n");
        sb.append("Nom de la population   : ");
        sb.append(this.nom);
        sb.append("\n");
        sb.append("Algorithme             : ");
        sb.append(this.getAlgorithme());
        sb.append("\n");
        sb.append("Taux de mutation       : ");
        sb.append(this.getTauxMutation());
        sb.append("\n");
        sb.append("Taux de croisement     : ");
        sb.append(this.getTauxCroisement());
        sb.append("\n");
        sb.append("S\u00e9lection              : ");
        switch (this.getSelection()) {
            case 0: {
                sb.append("RANG");
                break;
            }
            case 2: {
                sb.append("ROULETTE_PIPEE");
                break;
            }
            case 3: {
                sb.append("RESTE_STOCHASTIQUE");
                break;
            }
            case 1: {
                sb.append("TOURNOI");
                break;
            }
            default: {
                sb.append("ERREUR");
            }
        }
        sb.append("\n");
        sb.append("Nb de participant      : ");
        sb.append(this.getNbPartTournoi());
        sb.append("\n");
        sb.append("Scaling                : ");
        sb.append(this.getScaling() ? "TRUE" : "FALSE");
        sb.append("\n");
        sb.append("Sharing                : ");
        sb.append(this.getSharing() ? "TRUE" : "FALSE");
        sb.append("\n");
        sb.append("Alpha                  : ");
        sb.append(this.getAlpha());
        sb.append("\n");
        sb.append("SigmaShare             : ");
        sb.append(this.getSigmaShare());
        sb.append("\n");
        sb.append("Crowding               : ");
        sb.append(this.getCrowding() ? "TRUE" : "FALSE");
        sb.append("\n");
        sb.append("Croisement restreint   : ");
        sb.append(this.getCroisementRestreint() ? "TRUE" : "FALSE");
        sb.append("\n");
        sb.append("Elitisme               : ");
        sb.append(this.getElitisme() ? "TRUE" : "FALSE");
        sb.append("\n");
        sb.append("Nb de meilleurs copi\u00e9s : ");
        sb.append(this.getNbMeilleurs());
        sb.append("\n");
        sb.append("Remplacement           : ");
        switch (this.getRemplacement()) {
            case 20: {
                sb.append("ENFANT_PARENT");
                break;
            }
            case 22: {
                sb.append("LES_PLUS_MAUVAIS");
                break;
            }
            case 21: {
                sb.append("ALEATOIRE");
                break;
            }
            case 23: {
                sb.append("TOURNOI_INVERSE");
                break;
            }
            case 24: {
                sb.append("LES_PLUS_VIEUX");
                break;
            }
            case 25: {
                sb.append("PERSO");
                break;
            }
            default: {
                sb.append("ERREUR");
            }
        }
        sb.append("\n");
        sb.append("Nb d'individus en supp : ");
        sb.append(this.getNbOverlap());
        sb.append("\n");
        sb.append("Tdom                   : ");
        sb.append(this.getTdom());
        sb.append("\n");
        sb.append("-----------------------\n");
        return sb.toString();
    }
}

