/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.rhul.cs.stats.curvefitting;

import uk.ac.rhul.cs.stats.curvefitting.StraightLineFit;
import uk.ac.rhul.cs.stats.datastructures.PairedData;

public class LineFit
implements StraightLineFit {
    protected PairedData data;
    private boolean calculated = false;
    private boolean analysed = false;
    protected double meanX;
    protected double meanY;
    protected double calculatedA;
    protected double calculatedB;
    protected double rss;

    public LineFit(PairedData data) {
        this.data = data;
    }

    protected void calculate() {
        if (this.calculated) {
            return;
        }
        this.calculated = true;
        double[] xs = this.data.getX();
        double[] ys = this.data.getY();
        double xx_bar = 0.0;
        double xy_bar = 0.0;
        int n = xs.length;
        if (n == 0) {
            this.calculatedA = Double.NaN;
            this.calculatedB = Double.NaN;
            return;
        }
        for (double x : xs) {
            this.meanX += x;
        }
        this.meanX /= (double)n;
        for (double y : ys) {
            this.meanY += y;
        }
        this.meanY /= (double)n;
        for (int i = 0; i < n; ++i) {
            double xdiff = xs[i] - this.meanX;
            double ydiff = ys[i] - this.meanY;
            xx_bar += xdiff * xdiff;
            xy_bar += xdiff * ydiff;
        }
        this.calculatedA = xy_bar / xx_bar;
        this.calculatedB = this.meanY - this.calculatedA * this.meanX;
    }

    protected void analyse() {
        if (this.analysed) {
            return;
        }
        this.analysed = true;
        this.calculate();
        double[] xs = this.data.getX();
        double[] ys = this.data.getY();
        int n = xs.length;
        this.rss = 0.0;
        for (int i = 0; i < n; ++i) {
            double fit = this.calculatedA * xs[i] + this.calculatedB;
            this.rss += (ys[i] - fit) * (ys[i] - fit);
        }
    }

    public double getA() {
        this.calculate();
        return this.calculatedA;
    }

    public double getB() {
        this.calculate();
        return this.calculatedB;
    }

    public double getMeanX() {
        this.calculate();
        return this.meanX;
    }

    public double getMeanY() {
        this.calculate();
        return this.meanY;
    }

    public double getSumOfSquares() {
        this.analyse();
        return this.rss;
    }
}

