/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.rhul.cs.cl1.ui.cytoscape3;

import java.util.WeakHashMap;
import org.cytoscape.model.CyEdge;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNode;
import org.cytoscape.model.CyRow;
import org.cytoscape.model.events.NetworkAboutToBeDestroyedEvent;
import org.cytoscape.model.events.NetworkAboutToBeDestroyedListener;
import uk.ac.rhul.cs.cl1.ui.cytoscape3.ClusterONECytoscapeApp;
import uk.ac.rhul.cs.cl1.ui.cytoscape3.ControlPanel;
import uk.ac.rhul.cs.cl1.ui.cytoscape3.Graph;
import uk.ac.rhul.cs.cl1.ui.cytoscape3.NonNumericAttributeException;
import uk.ac.rhul.cs.utils.ObjectUtils;
import uk.ac.rhul.cs.utils.Pair;
import uk.ac.rhul.cs.utils.UniqueIDGenerator;

public class CyNetworkCache
implements NetworkAboutToBeDestroyedListener {
    WeakHashMap<CyNetwork, Pair<String, Graph>> storage = new WeakHashMap();
    private ClusterONECytoscapeApp app;

    public CyNetworkCache(ClusterONECytoscapeApp app) {
        this.app = app;
        app.registerService(this, NetworkAboutToBeDestroyedListener.class);
    }

    public Graph convertCyNetworkToGraph(CyNetwork network, String weightAttr) throws NonNumericAttributeException {
        Pair<String, Graph> attrNameAndGraph = this.storage.get(network);
        if (attrNameAndGraph != null && ObjectUtils.equals(weightAttr, attrNameAndGraph.getLeft())) {
            return attrNameAndGraph.getRight();
        }
        Graph graph = new Graph(network);
        UniqueIDGenerator<CyNode> nodeIdGen = new UniqueIDGenerator<CyNode>(graph);
        try {
            for (CyEdge edge : network.getEdgeList()) {
                Double weight;
                int dest;
                int src = nodeIdGen.get(edge.getSource());
                if (src == (dest = nodeIdGen.get(edge.getTarget()))) continue;
                if (weightAttr == null) {
                    weight = null;
                } else {
                    CyRow row = network.getRow((CyIdentifiable)edge);
                    weight = (Double)row.get(weightAttr, Double.class, (Object)1.0);
                }
                if (weight == null) {
                    weight = 1.0;
                }
                graph.createEdge(src, dest, weight);
            }
        }
        catch (ClassCastException ex) {
            throw new NonNumericAttributeException(weightAttr);
        }
        graph.setNodeMapping(nodeIdGen.getReversedList());
        this.storage.put(network, Pair.create(weightAttr, graph));
        return graph;
    }

    public Graph convertCyNetworkToGraph(CyNetwork network) throws NonNumericAttributeException {
        ControlPanel panel = this.app.getControlPanel();
        if (panel == null) {
            return this.convertCyNetworkToGraph(network, null);
        }
        return this.convertCyNetworkToGraph(network, panel.getWeightAttributeName());
    }

    public void invalidate(CyNetwork network) {
        if (network != null) {
            this.storage.remove(network);
        }
    }

    public void handleEvent(NetworkAboutToBeDestroyedEvent event) {
        this.invalidate(event.getNetwork());
    }
}

